<div class="header-block-property" <?php echo isset($property['BlurredImage'][0]) ? 'data-bg="' . $property['BlurredImage'][0]['filepath'] . '"' : ''; ?>>
	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-12">
				<h1>
					<?php echo $property['Property']['bedrooms']; ?> bedroom <?php echo strtolower($property['Property']['display_type']); ?>
					<span class="hidden-xs">| <?php echo $property['Property']['display']; ?></span>
				</h1>
			</div>
		</div>
	</div>
</div>

<div class='content property-detail'>
	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-12 col-sm-3" id="property-details-left">
				<div class="row" id="property-details-price">
					<div class="col-xs-12 col-sm-6">
						<h2 class="hidden-xs"><?php echo $this->Number->currency($property['Property']['price'], 'GBP', array('places' => 0)); ?></h2>
						<div class="row visible-xs">
							<div class="col-xs-6">
								<h2><?php echo $this->Number->currency($property['Property']['price'], 'GBP', array('places' => 0)); ?></h2>
							</div>
							<div class="col-xs-6 gutterless--left">
								<p class="address">
									<?php echo $property['Property']['display']; ?>
								</p>
							</div>
						</div>
					</div>
					<div class="col-sm-6 hidden-xs">
						<div class="row">
							<div class="col-md-1 gutterless">
								|
							</div>
							<div class="col-md-11 gutterless">
								<span>
									<?php echo $property['Property']['bedrooms']; ?> bedroom <?php echo strtolower($property['Property']['display_type']); ?>
								</span>
							</div>
						</div>
					</div>
				</div>

				<div class="row mortgage">
					<div class="col-xs-1 gutterless--right">
						<i class="fa fa-pencil-square"></i>
					</div>
					<div class="col-xs-11">
						<a href="<?php echo $this->Html->url('/mortgages'); ?>">
							How much would a mortgage be each month?
						</a>
					</div>
				</div>

				<div class="row mortgage">
					<div class="col-xs-1 gutterless--right">
						<i class="fa fa-gbp"></i>
					</div>
					<div class="col-xs-11">
						<a href="<?php echo $this->Html->url('/selling'); ?>">
							How much is my property worth?
						</a>
					</div>
				</div>

				<div class="row">
					<div class="col-xs-12">
						<p class="address hidden-xs">
							<?php echo $property['Property']['display']; ?>
						</p>
					</div>
				</div>

				<div class="row hidden-xs">
					<div class="col-xs-12">
						<div id="fb-root"></div>
						<div class="facebook">
							<iframe src="//www.facebook.com/plugins/like.php?href=<?php echo $this->Html->url(null, true); ?>&amp;width&amp;layout=button_count&amp;action=like&amp;show_faces=false&amp;share=false&amp;height=21" scrolling="no" frameborder="0" style="border:none; overflow:hidden; height:21px;" allowTransparency="true">
							</iframe>
						</div>

						<div class="twitter">
							<a href="https://twitter.com/share" class="twitter-share-button">Tweet</a>
							<script>
								!function(d, s, id) {
									var js, fjs = d.getElementsByTagName(s)[0], p = /^http:/.test(d.location) ? 'http' : 'https';
									if (!d.getElementById(id)) {
										js = d.createElement(s);
										js.id = id;
										js.src = p + '://platform.twitter.com/widgets.js';
										fjs.parentNode.insertBefore(js, fjs);
									}
								}(document, 'script', 'twitter-wjs');
							</script>
						</div>
					</div>
				</div>

				<div class="row">
					<div class="col-xs-12 gutterless-md--right gutterless-lg--right">
						<a href="#" class="btn" id="arrange-viewing-button" data-toggle="modal" data-target="#arrange-viewing-modal">Arrange a Viewing</i></a>
					</div>
				</div>

				<div class="row call-us-on-block">
					<div class="col-xs-5 gutterless-sm gutterless-md gutterless-lg">
						<div class="call">
							Or call us on
						</div>
					</div>
					<div class="col-xs-7">
						<div class="call-us-on">
							<div class="row">
								<div class="col-xs-3 col-sm-1 gutterless text-right">
									<i class="fa fa--call fa-phone"></i>
								</div>
								<div class="col-xs-9 col-sm-11">
									<p class="branch-name"><?php echo isset($property['Branch']['name']) ? $property['Branch']['name'] : $property['Branch']['town']; ?>:</p>
									<p class="telephone"><?php echo $telephone; ?></p>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="row mortgage">
					<div class="col-xs-12">
						<div class="mailing-list">
							<i class="fa fa-envelope"></i>
							<a href="#" id="join-mailing-list-button" data-toggle="modal" data-target="#join-mailing-list-modal">Join our mailing list</a>
						</div>
					</div>
				</div>

				<div class="row mortgage">
					<div class="col-xs-12 gutterless-sm--right gutterless-md--right gutterless-lg--right">
						<div class="hr"></div>
					</div>
				</div>

				<div class="row">
					<div class="col-xs-12">
						<?php if (!isset($voteCookie)): ?>
								<div id="property-vote">
									<div class="like-this">
										<i class="fa fa-thumbs-up"></i> I like this property
									</div>
									<div class="dont-like">
										<i class="fa fa-thumbs-down"></i> I don’t like this property
									</div>

									<div class="dont-like-hidden">
										<form name="dislike">
											<div class="row">
												<div class="col-xs-12 col-md-6">
													<span><input type="radio" name="dont-like" class="negative-reason" value="Too Expensive" checked="checked" /><label>Too expensive</label></span>
													<span><input type="radio" name="dont-like" class="negative-reason" value="Poor Location" /><label>Poor Location </label></span>
												</div>
												<div class="col-xs-12 col-md-6">
													<span><input type="radio" name="dont-like" class="negative-reason" value="Needs Work" /><label>Needs Work</label></span>
													<span><input type="radio" name="dont-like" class="negative-reason" value="Other" /><label>Other</label></span>
												</div>
												<div class="col-xs-12">
													<a class="submit form-submit" href="#">Submit Reason <i class="fa fa-caret-right"></i></a>
												</div>
											</div>
										</form>
									</div>
								</div>
								<div id="property-vote-success" class="hidden">
									<p class="small success contact-form-msg">Thank you. Your vote has been submitted.</p>
								</div>
							<?php else: ?>
								<div id="already-voted">
									<p class="small success contact-form-msg">
										You have <strong><?php echo (!$voteCookie['positive'] ? 'dis' : '') ?>liked</strong> this property
									</p>
								</div>
						<?php endif; ?>
					</div>
				</div>
			</div>

			<div class="col-xs-12 col-sm-9 gutterless-xs" id="property-details-right">
				<div
					id="property-images"
					class="cycle-slideshow"
					data-cycle-fx="scrollHorz"
					data-cycle-timeout="5000"
					data-cycle-pause-on-hover="true"
					data-cycle-log="false"
					style="height: 450px; overflow: hidden;"
					>
						<?php foreach ($property['Image'] as $image): ?>
								<?php echo $this->Image->resize($image, array('width' => 860, 'crop' => false, 'class' => 'full')); ?>
							<?php endforeach; ?>
				</div>

				<div id="carousel" class="hidden-xs hidden-sm">
					<div class="row">
						<div class="col-xs-1 gutterless--right">
							<a href="#" class="cycle-prev"><i class="fa fa-caret-left"></i></a>
						</div>
						<div class="col-xs-10 gutterless">
							<div
								id="property-image-thumbs"
								class="cycle-slideshow hidden-xs"
								data-cycle-fx="carousel"
								data-cycle-carousel-visible="6"
								data-cycle-carousel-fluid="true"
								data-cycle-prev="#carousel .cycle-prev"
								data-cycle-next="#carousel .cycle-next"
								data-cycle-timeout="0"
								data-cycle-allow-wrap="false"
								data-cycle-log="false"
								data-allow-wrap="false"
								>
									<?php foreach ($property['Image'] as $image): ?>
											<?php echo $this->Image->resize($image, array('height' => 80, 'crop' => false)); ?>
										<?php endforeach; ?>
							</div>
						</div>
						<div class="col-xs-1 gutterless--left">
							<a href="#" class="cycle-next"><i class="fa fa-caret-right"></i></a>
						</div>
					</div>
				</div>

			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 gutterless-xs">
				<div id="property-details-bottom">
					<?php echo $this->Element('property_tabs'); ?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php echo $this->Element('arrange_viewing_modal'); ?>
<?php echo $this->Element('mailing_list_modal'); ?>