<div class="header-block-page">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12">
				<h1><?php echo $data['Page']['title']; ?></h1>
			</div>
		</div>
	</div>
</div>
<div class='content sold-gallery'>
	<div class="container-fluid">
		<div class="row">
			<div class="col-xs-12">
				<?php echo $this->Session->flash('error'); ?>
			</div>
		</div>
		<?php if (!empty($rows)): ?>
				<div class="row">
					<div class="col-xs-12 col-sm-3">
						<?php echo $data['Page']['body']; ?>
					</div>

					<div class="col-xs-12 col-sm-9">
						<div class="multi-marker-map" id="sold-locations-map" data-locations="map-locations" data-zoomLevel="12" data-marker="/theme/Site/img/sold-map-marker.png"></div>
					</div>
				</div>

				<?php foreach ($rows as $row): ?>
					<div class="row">
						<?php foreach ($row as $property): ?>
							<div class="property col-xs-6 col-md-4 col-lg-3">
								<div class="row">
									<div class="col-xs-12">
										<div class="property-img">
											<?php if (isset($property['Image'][0])): ?>
												<div class="sash"></div>
												<?php echo $this->Image->resize($property['Image'][0], array('class' => 'main-img full', 'width' => 270, 'height' => 175, 'crop' => false)); ?>
											<?php endif; ?>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-xs-12">
										<div class="property-details">
											<div class="row">
												<div class="col-md-6 gutterless--right">
													<h4>
														<?php echo $this->Number->currency($property['Property']['price'], 'GBP', array('places' => 0)); ?>
													</h4>
												</div>
												<div class="col-md-6 gutterless--left">
													<span>| <?php echo $property['Property']['bedrooms']; ?> bedroom</span>
												</div>
											</div>
											<div class="row">
												<div class="col-md-12">
													<p class="info"><?php echo $property['Property']['display']; ?></p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				<?php endforeach; ?>

				<?php if (!empty($mapLocations)): ?>
					<div id="map-locations" class="hidden">
						<?php foreach ($mapLocations as $location): ?>
							<div class="map-location" data-lat="<?php echo $location['Property']['latitude']; ?>" data-long="<?php echo $location['Property']['longitude']; ?>"></div>
						<?php endforeach; ?>
					</div>
				<?php endif; ?>

				<div class="row">
					<div class="col-sm-12 page-select page-selector">
						<?php if ($this->Paginator->hasPrev()): ?>
							<?php echo $this->Paginator->prev('<i class="fa fa-caret-left"></i>' . __('Previous'), array('escape' => false)); ?>
						<?php endif; ?>

						<?php
						echo $this->Paginator->numbers(array(
							'separator' => '',
							'currentClass' => 'page active',
							'class' => 'page',
						));
						?>

						<?php if ($this->Paginator->hasNext()): ?>
							<?php echo $this->Paginator->next(__('Next') . '<i class="fa fa-caret-right"></i>', array('escape' => false)); ?>
						<?php endif; ?>
					</div>
				</div>
			<?php else: ?>
				<div class="row">
					<div class="col-xs-12">
						<h2>Sorry, there aren't any recently sold properties to display.</h2>
					</div>
				</div>
		<?php endif; ?>
	</div>
</div>

</html>