<div class="header-block-page">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12"><h1>Properties for sale</h1></div>
		</div>
	</div>
</div>

<div class='content property' id="map-view">
	<div class="container-fluid">
		<?php echo $this->Element('property-view-options', array('disable_sort' => true)); ?>
		<div class="row">
			<div class="col-md-12">
				<p class="alert-warning">
					<?php if (count($properties) == Configure::read('SiteSetting.max_map_properties')): ?>
							Please note that only the first <?php echo Configure::read('SiteSetting.max_map_properties'); ?> properties are shown here.
							You can use the property search on this page to refine your results.
						<?php endif; ?>
				</p>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-5 col-md-3">
				<?php echo $this->Element('property-filters-map'); ?>
			</div>

			<div class="col-xs-12 col-sm-7 col-md-9">
				<?php if (!empty($properties)): ?>
						<div
							class="multi-marker-map"
							id="property-map"
							data-locations="map-locations"
							data-zoomLevel="5"
							data-marker="/theme/Site/img/locator.png"
							style="height: <?php echo $mapHeight; ?>px;"
							></div>
						<div id="map-locations" class="hidden">
							<?php foreach ($properties as $property): ?>
								<?php $elementId = 'property-info-' . $property['Property']['id']; ?>
								<div
									class="map-location"
									data-lat="<?php echo $property['Property']['latitude']; ?>"
									data-long="<?php echo $property['Property']['longitude']; ?>"
									data-overlay="<?php echo $elementId; ?>"
									>
								</div>
							<?php endforeach; ?>
						</div>
						<div class="map-overlays hidden">
							<?php foreach ($properties as $property): ?>
								<?php $elementId = 'property-info-' . $property['Property']['id']; ?>
								<div class="map-overlay" id="<?php echo $elementId; ?>">
									<div class="property-image">
										<?php if (isset($property['Image'][0])): ?>
											<a href="<?php echo $this->Html->url(array('controller' => 'properties', 'action' => 'view', $property['Property']['id'])); ?>" class="property-details-image">
												<?php echo $this->Image->resize($property['Image'][0], array('crop' => true, 'width' => 270, 'height' => 200, 'class' => 'full')); ?>
												<div class="img-count"><i class="fa fa-camera"></i> <?php echo count($property['Image']); ?></div>
											</a>
										<?php endif; ?>
									</div>
									<div class="property-details">
										<div class="row property-details-header">
											<div class="col-xs-12">
												<a href="<?php echo $this->Html->url(array('controller' => 'properties', 'action' => 'view', $property['Property']['id'])); ?>">
													<h2>
														<?php echo $this->Number->currency($property['Property']['price'], 'GBP', array('places' => 0)); ?>
													</h2>
													<div class="bedrooms">
														<span>|</span>
														<p>
															<?php echo $property['Property']['bedrooms']; ?> bed <?php echo strtolower($property['Property']['display_type']); ?>
														</p>
													</div>
													<div class="clear"></div>
												</a>
											</div>
										</div>
										<div class="row">
											<div class="col-xs-12">
												<div class="property-details-body">
													<h3><?php echo $property['Property']['display']; ?></h3>
													<p>
														<?php echo $this->Text->truncate($property['Property']['description'], 150); ?>
													</p>
												</div>
											</div>
										</div>
									</div>
									<div class="clear"></div>
								</div>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
			</div>
		</div>
	</div>
</div>

