<div class="header-block-page">
	<div class="container-fluid">
		<div class="row">
			<div class="col-12"><h1>Properties for sale</h1></div>
		</div>
	</div>
</div>

<div class='content property'>
	<div class="container-fluid">
		<?php echo $this->Session->flash('error'); ?>
		<?php echo $this->Element('property-view-options', array('disable_sort' => false)); ?>
		<?php echo $this->Element('property-filters-index'); ?>

		<div class="row">
			<div class="col-12">
				<div class="result-count">
					<?php echo $this->Paginator->counter('{:start} - {:end} of {:count}'); ?> <span>properties for sale</span>
				</div>
			</div>
		</div>

		<?php $i = 4; ?>
		<?php foreach ($properties as $property): ?>
				<div class="row">
					<div class="col-xs-12 gutterless--right gutterless-xs--left listing-wrapper">
						<div class="property-listing">
							<?php
							$mainImageOptions = array(
								'class' => 'main-img',
								'width' => 370,
								'height' => 268,
								'crop' => true
							);

							$thumbnailImageOptions = array(
								'width' => 102,
								'height' => 67,
								'crop' => true
							);
							?>
							<div class="listing-image">
								<a class="current-image" href="<?php echo $this->Html->url(array('controller' => 'properties', 'action' => 'view', $property['Property']['id'])); ?>">
									<?php if (in_array($property['Property']['web_status'], array(Property::STATUS_SSTC, Property::STATUS_VEBRA_SSTC))): ?>
										<div class="image-sash sstc">
											<?php echo $this->Html->image('sash-sstc.png'); ?>
										</div>
									<?php endif; ?>
									<?php if (isset($property['Image'][0])): ?>
										<?php echo $this->Image->resize($property['Image'][0], $mainImageOptions); ?>
									<?php endif; ?>
									<div class="img-count"><i class="fa fa-camera"></i> <?php echo count($property['Image']); ?></div>
									<div class="clear"></div>
								</a>

								<div class="img-right visible-lg">
									<?php if (!empty($property['Image'])): ?>
										<?php echo $this->Image->resize($property['Image'][0], array_merge($thumbnailImageOptions, array('data-large-image' => $property['Image'][0]['id']))); ?>
										<?php echo $this->Image->resize($property['Image'][1], array_merge($thumbnailImageOptions, array('data-large-image' => $property['Image'][1]['id']))); ?>
										<?php echo $this->Image->resize($property['Image'][2], array_merge($thumbnailImageOptions, array('data-large-image' => $property['Image'][2]['id']))); ?>
										<?php echo $this->Image->resize($property['Image'][3], array_merge($thumbnailImageOptions, array('class' => 'hidden-xs', 'data-large-image' => $property['Image'][3]['id']))); ?>
									<?php endif; ?>
								</div>

								<div id="large-image-holder" class="hidden">
									<?php if (!empty($property['Image'])): ?>
										<?php echo $this->Image->resize($property['Image'][0], array_merge($mainImageOptions, array('data-id' => $property['Image'][0]['id']))); ?>
										<?php echo $this->Image->resize($property['Image'][1], array_merge($mainImageOptions, array('data-id' => $property['Image'][1]['id']))); ?>
										<?php echo $this->Image->resize($property['Image'][2], array_merge($mainImageOptions, array('data-id' => $property['Image'][2]['id']))); ?>
										<?php echo $this->Image->resize($property['Image'][3], array_merge($mainImageOptions, array('data-id' => $property['Image'][3]['id']))); ?>
									<?php endif;
									?>
								</div>
							</div>

							<div class = "property-details">
								<a href = "<?php echo $this->Html->url('/properties/view/' . $property['Property']['id']); ?>">
									<div class = "details-header">
										<h3>
											<?php echo $this->Number->currency($property['Property']['price'], 'GBP', array('places' => 0));
											?>
											<span> | <?php echo $property['Property']['bedrooms']; ?> bedroom <?php echo strtolower($property['Property']['display_type']); ?></span>
										</h3>
										<i class="fa fa-caret-right hidden-xs"></i>
									</div>
								</a>

								<h4><?php echo $property['Property']['display']; ?></h4>
								<p><?php echo $this->Text->truncate($property['Property']['description'], 400); ?></p>
								<p><a href="<?php echo $this->Html->url('/properties/view/' . $property['Property']['id']); ?>">View Property <i class="fa fa-caret-right"></i></a><p>
							</div>
						</div>
					</div>
				</div>
				<?php $i--; ?>
			<?php endforeach; ?>

		<div class="row">
			<div class="col-sm-12 page-select page-selector">
				<?php if ($this->Paginator->hasPrev()): ?>
						<?php echo $this->Paginator->prev('<i class="fa fa-caret-left"></i>' . __('Previous'), array('escape' => false)); ?>
					<?php endif; ?>

				<?php
					echo $this->Paginator->numbers(array(
						'separator' => '',
						'currentClass' => 'page active',
						'class' => 'page',
					));
				?>

				<?php if ($this->Paginator->hasNext()): ?>
						<?php echo $this->Paginator->next(__('Next') . '<i class="fa fa-caret-right"></i>', array('escape' => false)); ?>
					<?php endif; ?>
			</div>
		</div>
	</div>
</div>

