
<div class='tabs' id="property-details-tabs">
	<div class='tabs__buttons'>
		<ul>
			<?php if (isset($property['Paragraph']) && !empty($property['Paragraph'])): ?>
				<li>
					<a href='#tabs__1'>Full Description</a>
				</li>
			<?php endif; ?>
			<?php if (!empty($property['FloorplanImage'])): ?>
				<li>
					<a href='#tabs__2'>Floor Plans</a>
				</li>
			<?php endif; ?>
			<?php if ((!empty($property['DetailmapImage']) || !empty($property['StreetmapImage']) || !empty($property['TownmapImage'])) && !$isMobile): ?>
				<li>
					<a href='#tabs__3'>Site Plans</a>
				</li>
			<?php endif; ?>
			<?php if ((isset($property['Property']['latitude']) && !empty($property['Property']['latitude'])) && (isset($property['Property']['longitude']) && !empty($property['Property']['longitude']))): ?>
				<li>
					<a href='#tabs__4'>View Map</a>
				</li>
				<?php if (!$isMobile): ?>
					<li>
						<a href='#tabs__5'>Street View</a>
					</li>
				<?php endif; ?>
			<?php endif; ?>
			<?php if (!empty($property['Property']['tour_url']) && filter_var($property['Property']['tour_url'], FILTER_VALIDATE_URL) !== false): ?>	
				<li id="tour-tab">
					<a href='#tabs__7'>Photo Tour</a>
				</li>			
			<?php endif; ?>
			<?php if (!empty($property['EpcImage']) && !$isMobile): ?>
				<li>
					<a href='#tabs__6'>EPCs</a>
				</li>
			<?php endif; ?>
		</ul>
	</div>

	<?php
		$fullImage = array('class' => 'full', 'crop' => false);
	?>

	<?php if (isset($property['Paragraph']) && !empty($property['Paragraph'])): ?>
			<div id='tabs__1'>
				<div class="tabs__content">
					<div class="row">
						<div class="col-xs-12">
							<p><?php echo $property['Property']['description']; ?></p>
						</div>
					</div>
					<?php
					$columns = array_chunk($property['Paragraph'], ceil(sizeof($property['Paragraph']) / 2));
					?>
					<div class="row">
						<?php foreach ($columns as $column): ?>
							<div class="col-xs-12 col-sm-6">
								<?php foreach ($column as $paragraph): ?>
									<div class="paragraph">
										<h3><?php echo $paragraph['name']; ?> <?php if(isset($paragraph['dimensions_mixed'])) { echo '<em>'.$paragraph['dimensions_mixed'].'</em>'; } ?></h3>
										<p><?php echo $paragraph['text']; ?></p>
									</div>
								<?php endforeach; ?>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		<?php endif; ?>

	<?php if (!empty($property['FloorplanImage'])): ?>
		<div id='tabs__2'>
			<div class="tabs__content">
				<?php foreach ($property['FloorplanImage'] as $image): ?>
					<div><?php echo $this->Image->resize($image, $fullImage); ?></div>
				<?php endforeach; ?>
				<?php if ($isMobile): ?>
					<?php if (!empty($property['DetailmapImage'])): ?>
						<?php foreach ($property['DetailmapImage'] as $image): ?>
							<div><?php echo $this->Image->resize($image, $fullImage); ?></div>
						<?php endforeach; ?>
					<?php endif; ?>

					<?php if (!empty($property['StreetmapImage'])): ?>
						<?php foreach ($property['StreetmapImage'] as $image): ?>
							<div><?php echo $this->Image->resize($image, $fullImage); ?></div>
						<?php endforeach; ?>
					<?php endif; ?>

					<?php if (!empty($property['TownmapImage'])): ?>
						<?php foreach ($property['TownmapImage'] as $image): ?>
							<div><?php echo $this->Image->resize($image, $fullImage); ?></div>
						<?php endforeach; ?>
					<?php endif; ?>
				<?php endif; ?>
			</div>
		</div>
	<?php endif; ?>

	<?php if ((!empty($property['DetailmapImage']) || !empty($property['StreetmapImage']) || !empty($property['TownmapImage'])) && !$isMobile): ?>
			<div id='tabs__3'>
				<div class="tabs__content">
					<?php if (!empty($property['DetailmapImage'])): ?>
						<?php foreach ($property['DetailmapImage'] as $image): ?>
							<div><?php echo $this->Image->resize($image, $fullImage); ?></div>
						<?php endforeach; ?>
					<?php endif; ?>

					<?php if (!empty($property['StreetmapImage'])): ?>
						<?php foreach ($property['StreetmapImage'] as $image): ?>
							<div><?php echo $this->Image->resize($image, $fullImage); ?></div>
						<?php endforeach; ?>
					<?php endif; ?>

					<?php if (!empty($property['TownmapImage'])): ?>
						<?php foreach ($property['TownmapImage'] as $image): ?>
							<div><?php echo $this->Image->resize($image, $fullImage); ?></div>
						<?php endforeach; ?>
					<?php endif; ?>
				</div>
			</div>
		<?php endif; ?>

	<?php if ((isset($property['Property']['latitude']) && !empty($property['Property']['latitude'])) && (isset($property['Property']['longitude']) && !empty($property['Property']['longitude']))): ?>
			<div id='tabs__4' class="property-details-google-map">
				<div class="tabs__content">
					<div
						id="property-details-map"
						data-lat="<?php echo $property['Property']['latitude']; ?>"
						data-lng="<?php echo $property['Property']['longitude']; ?>"
						data-zoomLevel="16"
						style="width: 100%; height: 500px;">
					</div>
				</div>
			</div>
			<?php if (!$isMobile): ?>
				<div id='tabs__5' class="property-details-google-streetview">
					<div class="tabs__content">
						<div
							class="street_view"
							id="property-details-streetview"
							data-lat="<?php echo $property['Property']['latitude']; ?>"
							data-long="<?php echo $property['Property']['longitude']; ?>"
							style="width: 100%; height: 500px; float: left;">
						</div>
					</div>
				</div>
			<?php endif; ?>
		<?php endif;
	?>
	
	<?php if(!empty($property['Property']['tour_url']) && filter_var($property['Property']['tour_url'], FILTER_VALIDATE_URL) !== false): ?>
	
		<div id="tabs__7">
			<div class="tabs__content">
				<div class="property-tour-outer">
					<iframe name="metropix" id="mpif" class="property-tour" src="<?php echo $property['Property']['tour_url']; ?>" scrolling="no"></iframe>
					<a href="<?php echo $property['Property']['tour_url']; ?>" id="mplk" target="_blank">&nbsp;ss</a>
				</div>
			</div>
		</div>
	
	<?php endif; ?>

	<?php if (!empty($property['EpcImage']) && !$isMobile): ?>
			<div id='tabs__6'>
				<div class="tabs__content">
					<?php foreach ($property['EpcImage'] as $image): ?>
						<div><?php echo $this->Image->resize($image); ?></div>
					<?php endforeach; ?>
				</div>
			</div>
		<?php endif; ?>
</div>