
<form name="sort-properties-by" method="post" class="pull-right form-inline hidden-xs">
	<div class="row">
		<div class="col-md-5 gutterless-sm gutterless-md gutterless-lg">
			<label class="order-by<?php echo ($disable_sort ? ' disabled' : '') ?>">Order results by</label>
		</div>
		<div class="col-md-7 gutterless-sm gutterless-md gutterless-lg">
			<?php
				$regex = '/(\/(sort|direction):[^\/]*)/';

				if (preg_match('/\/sort:([^\/]*)/', $this->here, $matches)) {
					$sort = $matches[1];
				} else {
					$sort = null;
				}

				if (preg_match('/\/direction:([^\/]*)/', $this->here, $matches)) {
					$direction = $matches[1];
				} else {
					$direction = null;
				}
			?>
			<select<?php echo ($disable_sort ? ' disabled="disabled"' : '') ?>>
				<option
					value="price-desc"
					<?php if ($sort === 'price' && $direction === 'desc'): ?>selected="selected"<?php endif; ?>
					data-url="<?php echo preg_replace($regex, '', rtrim($this->here, '/')) . '/sort:price/direction:desc'; ?>"
					>
					Price - Highest First
				</option>
				<option
					value="price-asc"
					<?php if ($sort === 'price' && $direction === 'asc'): ?>selected="selected"<?php endif; ?>
					data-url="<?php echo preg_replace($regex, '', rtrim($this->here, '/')) . '/sort:price/direction:asc'; ?>"
					>
					Price - Lowest First
				</option>
				<option
					value="recent"
					<?php if ($sort === 'uploaded' && $direction === 'desc'): ?>selected="selected"<?php endif; ?>
					data-url="<?php echo preg_replace($regex, '', rtrim($this->here, '/')) . '/sort:uploaded/direction:desc'; ?>"
					>
					Most Recent
				</option>
			</select>
		</div>
	</div>
</form>