<div class="row property-filters-map">
	<?php echo $this->Element('property-filters/header'); ?>
	<div class="col-xs-12">
		<?php
			$searchOptions = array(
				'url' => array(
					'controller' => 'properties',
					'action' => 'map'
				),
				'inputDefaults' => array(
					'label' => false,
					'div' => false
				),
				'class' => 'form form-inline pull-right',
				'name' => 'filters'
			);
			echo $this->Form->create('property_filters', $searchOptions);
		?>
		<div class="row filter-row">
			<div class="col-xs-12">
				<label >Property location</label>
				<?php echo $this->Form->input('area'); ?>
			</div>
		</div>

		<div class="row filter-row">
			<div class="col-xs-12">
				<label>Search Radius</label>
				<?php
					echo $this->Form->input('radius', array(
						'options' => $radiusOptions,
						'empty' => 'Distance',
						'default' => 'exact',
						'class' => 'type-select',
						'id' => 'filters-radius'
					));
				?>
			</div>
		</div>

		<div class="row filter-row">
			<div class="col-xs-12">
				<label>Property Type</label>
				<?php
					echo $this->Form->input('type', array(
						'options' => $property_types,
						'empty' => 'All Property Types',
						'default' => '',
					));
				?>
			</div>
		</div>

		<div class="row filter-row">
			<div class="col-xs-12 filters-price">
				<label>Property Price</label>
				<?php
					echo $this->Form->input('min_price', array(
						'options' => $min_prices,
						'empty' => 'Any',
						'default' => '',
						'class' => 'price-select',
						'id' => 'filters-min-price'
					));
				?>
				<?php
					echo $this->Form->input('max_price', array(
						'options' => $max_prices,
						'empty' => 'Any',
						'default' => '',
						'class' => 'price-select',
						'id' => 'filters-max-price'
					));
				?>
			</div>
		</div>

		<div class="row filter-row">
			<div class="col-xs-12 filters-bedrooms">
				<label>Number Of Bedrooms</label>
				<?php
					echo $this->Form->input('min_bedrooms', array(
						'options' => $min_bedrooms,
						'empty' => 'Any',
						'default' => '',
						'class' => 'bedroom-select',
						'id' => 'filters-min-bedrooms'
					));
				?>
				<?php
					echo $this->Form->input('max_bedrooms', array(
						'options' => $max_bedrooms,
						'empty' => 'Any',
						'default' => '',
						'class' => 'bedroom-select',
						'id' => 'filters-max-bedrooms'
					));
				?>
			</div>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<a class="btn full form-submit" href="#">Update Search</a>
			</div>
		</div>
		<?php echo $this->Form->end(); ?>
	</div>
</div>