<div class="row property-filters-index">
	<?php echo $this->Element('property-filters/header'); ?>
	<div class="col-xs-12">
		<?php
			$searchOptions = array(
				'url' => array(
					'controller' => 'properties',
					'action' => 'index'
				),
				'inputDefaults' => array(
					'label' => false,
					'div' => false
				),
				'class' => 'form form-inline pull-right',
				'name' => 'filters'
			);
			echo $this->Form->create('property_filters', $searchOptions);
		?>
		<div class="row">
			<div class="col-xs-12 col-sm-6 col-md-4">
				<div class="row filter-row">
					<div class="col-xs-5">
						<label class="text-right">Property location</label>
					</div>
					<div class="col-xs-7 gutterless--left">
						<?php echo $this->Form->input('area'); ?>
					</div>
				</div>

				<div class="row filter-row">
					<div class="col-xs-5">
						<label>Search Radius</label>
					</div>
					<div class="col-xs-7 gutterless--left">
						<?php
							echo $this->Form->input('radius', array(
								'options' => $radiusOptions,
								'empty' => 'Distance',
								'default' => 'exact',
								'class' => 'type-select',
								'id' => 'filters-radius'
							));
						?>
					</div>
				</div>

				<div class="row filter-row">
					<div class="col-xs-5">
						<label>Property Type</label>
					</div>
					<div class="col-xs-7 gutterless--left">
						<?php
							echo $this->Form->input('type', array(
								'options' => $property_types,
								'empty' => 'All Property Types',
								'default' => '',
							));
						?>
					</div>
				</div>
			</div>

			<div class="col-xs-12 col-sm-6 col-md-5">
				<div class="row filters-price filter-row">
					<div class="col-xs-5">
						<label>Property Price</label>
					</div>
					<div class="col-xs-7 col-sm-3 gutterless--left">
						<?php
							echo $this->Form->input('min_price', array(
								'options' => $min_prices,
								'empty' => 'Any',
								'default' => '',
								'class' => 'price-select',
								'id' => 'filters-min-price'
							));
						?>
					</div>
					<div class="col-xs-5 hidden-sm hidden-md hidden-lg">&nbsp;</div>
					<div class="col-xs-7 col-sm-3 gutterless--left">
						<?php
							echo $this->Form->input('max_price', array(
								'options' => $max_prices,
								'empty' => 'Any',
								'default' => '',
								'class' => 'price-select',
								'id' => 'filters-max-price'
							));
						?>
					</div>
				</div>

				<div class="row filters-bedrooms filter-row">
					<div class="col-xs-5">
						<label>Number Of Bedrooms</label>
					</div>
					<div class="col-xs-7 col-sm-3 gutterless--left">
						<?php
							echo $this->Form->input('min_bedrooms', array(
								'options' => $min_bedrooms,
								'empty' => 'Any',
								'default' => '',
								'class' => 'bedroom-select',
								'id' => 'filters-min-bedrooms'
							));
						?>
					</div>
					<div class="col-xs-5 hidden-sm hidden-md hidden-lg">&nbsp;</div>
					<div class="col-xs-7 col-sm-3 gutterless--left">
						<?php
							echo $this->Form->input('max_bedrooms', array(
								'options' => $max_bedrooms,
								'empty' => 'Any',
								'default' => '',
								'class' => 'bedroom-select',
								'id' => 'filters-max-bedrooms'
							));
						?>
					</div>
				</div>
			</div>

			<div class="col-xs-12 col-sm-11 col-md-3">
				<a class="btn form-submit" href="#">Update Search</a>
			</div>			
		</div>
		<?php echo $this->Form->end(); ?>
	</div>

	<div class="col-xs-12">
		<div class="hr hidden-xs hidden-sm"></div>
	</div>
</div>