<?php

	App::uses('VebraAppModel', 'Vebra.Model');
	App::uses('Vebra', 'Vebra.Model');

	/**
	 * @property Vebra $Vebra
	 */
	class Property extends VebraAppModel {

		const STATUS_FOR_SALE = 0;
		const STATUS_UNDER_OFFER = 1;
		const STATUS_SOLD = 2;
		const STATUS_SSTC = 3;
		const STATUS_SALE_BY_AUCTION = 4;
		const STATUS_RESERVED = 5;
		const STATUS_NEW_INSTRUCTION = 6;
		const STATUS_JUST_ON_MARKET = 7;
		const STATUS_PRICE_REDUCTION = 8;
		const STATUS_KEEN_TO_SELL = 9;
		const STATUS_NO_CHAIN = 10;
		const STATUS_VENDOR_TO_PAY_STAMP = 11;
		const STATUS_OIRO = 12;
		const STATUS_GUIDE_PRICE = 13;
		const STATUS_VEBRA_FOR_SALE = 200;
		const STATUS_VEBRA_UNDER_OFFER = 201;
		const STATUS_VEBRA_SOLD = 202;
		const STATUS_VEBRA_SSTC = 203;
		const STATUS_VEBRA_LET = 214;
		const STATUS_VEBRA_NOT_MARKETED = 255;

		public $virtualFields = array(
			'full_address' => 'CONCAT_WS(", ", Property.name, Property.street, Property.locality, Property.town)'
		);
		public static $queryColumns = array(
			'name',
			'street',
			'locality',
			'town',
			'county',
			'postcode',
		);
		public static $typeMap = array(
			'Apartment' => 'Apartment',
			'Apartment - studio' => 'Studio apartment',
			'Barn conversion' => 'Barn conversion',
			'Bungalow - detached' => 'Detached bungalow',
			'Bungalow - semi detached' => 'Semi-detached bungalow',
			'Cottage' => 'Cottage',
			'Flat' => 'Flat',
			'House' => 'House',
			'House - detached' => 'Detached house',
			'House - semi-detached' => 'Semi-detached house',
			'House - terraced' => 'Terraced',
			'House - townhouse' => 'Townhouse'
		);
		public static $locationOverrides = array(
			'walton' => array(
				'lat' => 53.2193635,
				'lng' => -1.4589972,
			),
			'tapton' => array(
				'lat' => 53.2491869,
				'lng' => -1.4213098,
			),
			'tupton' => array(
				'lat' => 53.1870137,
				'lng' => -1.4165058,
			),
			'old tupton' => array(
				'lat' => 53.1870137,
				'lng' => -1.4165058,
			),			
			'new whittington' => array(
				'lat' => 53.2715608,
				'lng' => -1.4100988,
			),
		);
		public $actsAs = array(
			'MetaData.Meta',
		);
		public $imageSlots = array(
			'main' => array(// main property images
				'slots' => -1
			),
			'floorplan' => array(// floorplan images
				'slots' => -1
			),
			'detailmap' => array(// detail map images
				'slots' => -1
			),
			'streetmap' => array(// street map images
				'slots' => -1
			),
			'townmap' => array(// town map images
				'slots' => -1
			),
			'epc' => array(// energy efficiency rating images
				'slots' => -1
			),
			'blurred' => array(
				'slots' => 1
			)
		);
		public $documentSlots = array(
			'brochure' => array(// brochure images
				'slots' => -1
			)
		);
		public $hasMany = array(
			'Paragraph',
			'Vote'
		);
		public $belongsTo = 'Branch';

		public function isForSale($property) {
			if (!isset($property['Property']['web_status'])) {
				$this->log('You must pass in a cake-retrieved property array for this method to work');
				return false;
			}

			$forSaleStates = array(
				static::STATUS_FOR_SALE,
				static::STATUS_UNDER_OFFER,
				static::STATUS_SSTC,
				static::STATUS_SALE_BY_AUCTION,
				static::STATUS_RESERVED,
				static::STATUS_NEW_INSTRUCTION,
				static::STATUS_JUST_ON_MARKET,
				static::STATUS_PRICE_REDUCTION,
				static::STATUS_KEEN_TO_SELL,
				static::STATUS_NO_CHAIN,
				static::STATUS_VENDOR_TO_PAY_STAMP,
				static::STATUS_OIRO,
				static::STATUS_GUIDE_PRICE,
				static::STATUS_VEBRA_FOR_SALE,
				static::STATUS_VEBRA_UNDER_OFFER,
				static::STATUS_VEBRA_SSTC,
				static::STATUS_VEBRA_NOT_MARKETED
			);
			return in_array($property['Property']['web_status'], $forSaleStates);
		}

		public function showInSoldGallery($property) {
			if (!isset($property['Property']['show_in_main_listings'])) {
				$this->log('You must pass in a cake-retrieved property array for this method to work');
				return false;
			}

			/*$soldGalleryStates = array(
				static::STATUS_SSTC,
				static::STATUS_VEBRA_SSTC,
				static::STATUS_SOLD,
				static::STATUS_VEBRA_SOLD
			);
			return in_array($property['Property']['web_status'], $soldGalleryStates);*/
			
			return $property['Property']['show_in_main_listings']==1?false:true;
		}

		public function getVebraProperties($branchId) {
			$vebra = new Vebra();
			return $vebra->getProperties($branchId);
		}

		public function getVebraProperty($branchId, $propertyId) {
			$vebra = new Vebra();
			return $vebra->getProperty($branchId, $propertyId);
		}

		public function getVebraUpdatedProperties() {
			$vebra = new Vebra();
			return $vebra->getUpdatedProperties();
		}

		public function getMinPrices() {
			return $this->_getPricesFromTextarea(Configure::read('SiteSetting.min_prices'));
		}

		public function getMaxPrices() {
			return $this->_getPricesFromTextarea(Configure::read('SiteSetting.max_prices'));
		}

		protected function _getPricesFromTextarea($text) {
			$prices = explode("\n", $text);
			array_walk($prices, function(&$value) {
				$value = preg_replace('/(\.\d+|[^\d])/', '', $value); // replace any non-numerical characters, or decimal places, with nothing
			});

			$formattedPrices = array();
			foreach ($prices as $key => $value) {
				$numberFormatter = new CakeNumber();
				$formattedPrices[$value] = $numberFormatter->currency($value, 'GBP', array('places' => 0));
			}
			return $formattedPrices;
		}

		public function getStopwords() {
			return $this->_getStopwordsFromTextarea(Configure::read('SiteSetting.area_stopwords'));
		}

		protected function _getStopwordsFromTextarea($text) {
			return explode("\r\n", strtolower($text));
		}

		public function getRadiusOptions() {
			$options = $this->_getRadiusOptionsFromTextarea(Configure::read('SiteSetting.radius_options'));
			return array_merge(array('exact' => 'This area only'), $options);
		}

		protected function _getRadiusOptionsFromTextarea($text) {
			$options = explode("\n", $text);
			array_walk($options, function(&$value) {
				$value = preg_replace('/[^\d\.]/', '', $value); // replace any non-numerical characters, or decimal places, with nothing
			});

			$formattedOptions = array();
			foreach ($options as $key => $value) {
				$formattedOptions[$value] = $this->_formatRadius($value);
			}
			return $formattedOptions;
		}

		protected function _formatRadius($n, $tolerance = 1.e-6) {
			$quantifier = ($n > 1 ? 'miles' : 'mile');

			if (preg_match('/\./', $n)) {
				$h1 = 1;
				$h2 = 0;
				$k1 = 0;
				$k2 = 1;
				$b = 1 / $n;
				do {
					$b = 1 / $b;
					$a = floor($b);
					$aux = $h1;
					$h1 = $a * $h1 + $h2;
					$h2 = $aux;
					$aux = $k1;
					$k1 = $a * $k1 + $k2;
					$k2 = $aux;
					$b = $b - $a;
				} while (abs($n - $h1 / $k1) > $n * $tolerance);

				return "$h1/$k1 $quantifier";
			} else {
				return "$n $quantifier";
			}
		}

		public function getMinBedrooms() {
			return $this->_getBedroomsFromTextarea(Configure::read('SiteSetting.min_bedrooms'));
		}

		public function getMaxBedrooms() {
			return $this->_getBedroomsFromTextarea(Configure::read('SiteSetting.max_bedrooms'));
		}

		protected function _getBedroomsFromTextarea($text) {
			$bedrooms = explode("\n", $text);
			array_walk($bedrooms, function(&$value) {
				$value = preg_replace('/(\.\d+|[^\d])/', '', $value); // replace any non-numerical characters, or decimal places, with nothing
			});

			$formattedBedrooms = array();
			foreach ($bedrooms as $key => $value) {
				$formattedBedrooms[$value] = $value;
			}
			return $formattedBedrooms;
		}

		/**
		 * Pass in a database Image record and property ID, and this will do the rest.
		 * Technically we don't need the propertyId, as it's the model_id, but this makes it a bit clearer what we're doing
		 * @param Image|array $image
		 * @param int $propertyId
		 * @return boolean
		 * @throws Exception
		 */
		public function createBlurredImage($image, $propertyId) {
			// Make and save the new image
			switch ($image['type']) {
				case 'image/jpg' || 'image/jpeg':
					$original_image = imagecreatefromjpeg(WWW_ROOT . $image['filepath']);
					break;

				case 'image/png':
					$original_image = imagecreatefrompng(WWW_ROOT . $image['filepath']);
					break;

				case 'image/gif' || 'image/animated':
					$original_image = imagecreatefromgif(WWW_ROOT . $image['filepath']);
					break;

				default:
					throw new Exception('Image type not supported');
					break;
			}

			// blur the crap out of it. Note, this is VERY slow, so make sure it's done on import of properties
			for ($i = 0; $i < 100; $i++) {
				if (!imagefilter($original_image, IMG_FILTER_GAUSSIAN_BLUR)) {
					break; // don't bother keep going if we fail for some reason
				}
			}
			$blurred_image = $original_image;
			preg_match('/^image\/([a-zA-Z]{3,4})$/', $image['type'], $matches);
			$tmp_file = rtrim(ini_get('upload_tmp_dir'), DS) . DS . str_shuffle('abcdefghijklmnopqrstuvwxyz') . '.' . $matches[1];

			switch ($image['type']) {
				case 'image/jpg' || 'image/jpeg':
					$new_image = imagejpeg($blurred_image, $tmp_file);
					break;

				case 'image/png':
					$new_image = imagepng($blurred_image, $tmp_file);
					break;

				case 'image/gif' || 'image/animated':
					$new_image = imagegif($blurred_image, $tmp_file);
					break;

				default:
					throw new Exception('Image type not supported');
					break;
			}


			$imageData = array(
				'model' => 'Property',
				'model_id' => $propertyId,
				'filename' => array(
					'name' => $image['filename'],
					'type' => $image['type'],
					'size' => $image['size'],
					'tmp_name' => $tmp_file,
					'error' => 0,
				),
				'attachment_type' => 'BlurredImage',
				'type' => $image['type'],
			);

			$imageRecord = new Image();
			if ($imageRecord->create($imageData)) {
				$imageRecord->save();
				return true;
			} else {
				$this->log('Failed to save blurred image');
				return false;
			}
		}

	}
