<?php

	/*
	 * To change this license header, choose License Headers in Project Properties.
	 * To change this template file, choose Tools | Templates
	 * and open the template in the editor.
	 */

	/**
	 * Description of VotesController
	 *
	 * @author Luke
	 */
	class VotesController extends VebraAppController {

		public $components = array('Cookie');
		
		public function beforeFilter() {

			parent::beforeFilter();

			$this->Auth->allow(array(
				'positive',
				'negative'
			));
		}

		/**
		 * Add a positive vote for the given property
		 * @param int $propertyId
		 * @return boolean
		 */
		public function positive($propertyId, $reason) {
			return $this->_add($propertyId, true, $reason);
		}

		/**
		 * Add a negative vote for the given property
		 * @param int $propertyId
		 * @return boolean
		 */
		public function negative($propertyId, $reason) {
			return $this->_add($propertyId, false, $reason);
		}

		/**
		 * Add a vote for a property which is either positive or negative
		 * @param int $propertyId
		 * @param boolean $positive
		 * @return boolean
		 */
		protected function _add($propertyId, $positive = true, $reason = null) {
			$this->Vote->create();
			$data = array(
				'property_id' => $propertyId,
				'positive' => ($positive ? true : false),
				'negative_reason' => $reason
			);

			if ($this->Vote->save($data)) {
				$this->Cookie->write('Property.Vote.' . $propertyId, $data);
				if ($this->request->is('ajax', 'ajax')) {
					$this->render('Vebra.Common/ajax-default', 'ajax');
				} else {
					return true;
				}
			} else {
				if ($this->request->is('ajax', 'ajax')) {
					$this->render('Vebra.Common/ajax-default', 'ajax');
				} else {
					return false;
				}
			}
		}
		
		protected function _adminFilterFields() {
			
			$fields = parent::_adminFilterFields();
			
			$newFields = array();
			$newFields['Vote.id'] = $fields['Vote.id'];
			
			$newFields['Property.full_address'] = array(
				'label' => 'Name',
				'type' => 'string',
				'compare' => array(
					'CONCAT_WS(", ", Property.name, Property.street, Property.locality, Property.town) LIKE' => '%%%s%%'
				)
			);
			
			$newFields['Vote.created'] = $fields['Vote.created'];
			
			return $newFields;
		}

		protected function _adminIndexColumns() {
			$data = parent::_adminIndexColumns();
			$columns = array(
				'Vote.positive' => array(
					'type' => 'boolean',
					'label' => 'Positive Vote'
				),
				'0.full_address' => array(
					'type' => 'untouched',
					'label' => 'Property'
				),
				'Vote.negative_reason' => array(
					'type' => 'string',
					'label' => 'Reason'
				),
			);
			$adminColumns = ArrayUtil::addAfter($data, 'Vote.id', $columns);
			return $adminColumns;
		}

		protected function _adminIndexPaginate() {
			$data = parent::_adminIndexPaginate();
			$data['contain']['Property'] = array(
				'fields' => 'CONCAT_WS(", ", Property.name, Property.street, Property.locality, Property.town, Property.postcode) AS full_address'
			);
			return $data;
		}

		protected function _adminIndexActions() {
			return array();
		}

		protected function _adminIndexToolbar() {
			$toolbar = parent::_adminIndexToolbar();
			unset($toolbar['Add New']);
			return $toolbar;
		}

	}
