<?php

	App::uses('VebraAppController', 'Vebra.Controller');
	App::uses('Branch', 'Vebra.Model');

	/*
	 * To change this license header, choose License Headers in Project Properties.
	 * To change this template file, choose Tools | Templates
	 * and open the template in the editor.
	 */

	/**
	 * Description of PropertiesController
	 *
	 * @author Luke
	 */
	class PropertiesController extends VebraAppController {

		const FILTERS_FORM_NAME = 'property_filters';
		const SEARCH_RADIUS = 1; // search radius, in miles, from a given lat long pair.
		const PROPERTIES_PER_PAGE_MOBILE = 5;
		const PROPERTIES_PER_PAGE_DESKTOP = 10;

		public $components = array('EvContactForm.InjectContactForm', 'RequestHandler', 'Paginator', 'Cookie');
		public $helpers = array('EvContactForm.ShowContactForm');
		public $paginate = array(
			'limit' => 10,
			'order' => 'Property.price DESC',
			'contain' => array(
				'Paragraph',
				'Image'
			)
		);
		protected $allowedFilters = array(
			'area', // this needs to be in the URL, but we ignore it in the switch statement below
			'radius',
			'latitude',
			'longitude',
			'type',
			'min_price',
			'max_price',
			'min_bedrooms',
			'max_bedrooms',
			'sort',
			'direction'
		);
		protected $sort;
		protected $direction = 'ASC';

		public function beforeFilter() {
			parent::beforeFilter();
			$this->Auth->allow();
			return $this;
		}

		public function index() {

			$this->_setFilterData();

			if ($this->request->is('ajax')) {
				if (isset($this->request->data['mailing_list'])) {
					$this->set('name', 'mailing_list');
				} else if (isset($this->request->data['arrange_viewing'])) {
					$this->set('name', 'arrange_viewing');
				}
			}

			// Ge tavailable property types
			$this->Property->Behaviors->unload('MetaData.Meta');
			$propertyTypes = $this->Property->find('all', array(
				'fields' => array(
					'DISTINCT (Property.type) AS property_type',
				),
				'order' => array(
					'Property.type ASC'
				)
			));

			$propertyOptions = array();
			foreach ($propertyTypes as $type) {
				$propertyOptions[$type['Property']['property_type']] = $type['Property']['property_type'];
			}
			$this->set('propertyTypes', $propertyOptions);
			$priceRanges = array();
			foreach (explode("\r\n", Configure::read('SiteSetting.price_ranges')) as $range) {
				$priceRanges[$range] = $range;
			}
			$this->set('priceRanges', $priceRanges);
			$this->InjectContactForm->display(EV_CONTACT_FORM_MAILING_LIST, 'mailing_list');
			$this->InjectContactForm->display(EV_CONTACT_FORM_NO_MATCHES_FORM, 'no_matches_form');

			if ($this->request->is('ajax')) {
				$this->render('EvContactForm.Common/ajax-default', 'ajax');
			}

			if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data[static::FILTERS_FORM_NAME])) {
				$filter_url = $this->_buildFilterUrl($this->request->data[static::FILTERS_FORM_NAME]);
				return $this->redirect($filter_url);
			} else {
				$this->Paginator->settings = array(
					'limit' => $this->RequestHandler->isMobile() ? static::PROPERTIES_PER_PAGE_MOBILE : static::PROPERTIES_PER_PAGE_DESKTOP,
					'order' => 'Property.price DESC',
					'contain' => array(
						'Paragraph',
						'Image'
					)
				);

				$strictConditions = $this->_buildConditions($this->request->data[static::FILTERS_FORM_NAME], true);
				if($this->Property->find('count', array('conditions'=>$strictConditions)) > 0){
					$properties = $this->Paginator->paginate('Property', $strictConditions, array('price', 'uploaded'));
				}
				else {

					$properties = $this->Paginator->paginate('Property', $this->_buildConditions($this->request->data[static::FILTERS_FORM_NAME]), array('price', 'uploaded'));
				}



				$this->set('properties', $properties);
				$this->set('title_for_layout', 'All Properties | ' . Configure::read('SiteSetting.site_title'));
			}
		}

		public function map() {
			$this->_setFilterData();

			if (($this->request->is('post') || $this->request->is('put')) && isset($this->request->data[static::FILTERS_FORM_NAME])) {
				$filter_url = $this->_buildFilterUrl($this->request->data[static::FILTERS_FORM_NAME]);
				return $this->redirect($filter_url);
			} else {
				$options = $strictOptions = array(
					'conditions' => $this->_buildConditions($this->request->data[static::FILTERS_FORM_NAME]),
					'contain' => array(
						'Image',
						'Paragraph'
					),
					'limit' => Configure::read('SiteSetting.max_map_properties'),
					'order' => array(
						'Property.uploaded DESC', 'Property.price DESC'
					)
				);

				$strictOptions['conditions'] = $this->_buildConditions($this->request->data[static::FILTERS_FORM_NAME], true);
				$properties = $this->Property->find('all', $strictOptions);
				if (!$properties) {
					$properties = $this->Property->find('all', $options);
				}
				$this->set('properties', $properties);

				// Set the different image slide sizes for different devices
				if ($this->RequestHandler->isMobile()) {
					$mapHeight = 300;
				} else {
					$mapHeight = 580;
				}
				$this->set('mapHeight', $mapHeight);

				$this->set('isMobile', $this->RequestHandler->isMobile());

				$this->set('title_for_layout', 'All Properties | ' . Configure::read('SiteSetting.site_title'));
			}
		}

		public function view($id) {
			$params = array(
				'conditions' => array(
					'Property.id' => $id
				),
				'contain' => array(
					'Paragraph',
					'Image',
					'FloorplanImage',
					'DetailmapImage',
					'StreetmapImage',
					'TownmapImage',
					'EpcImage',
					'BlurredImage',
					'Branch',
				)
			);

			$property = $this->Property->find('first', $params);

			if (!$property) {
				$this->Session->setFlash('Sorry, the property you were looking for could not be found', 'default', array(), 'error');
				$this->redirect('/properties');
			} else if ($property['Property']['show_in_main_listings'] != 1) {
				$this->Session->setFlash('Sorry, this property has been sold. You can view it in the sold gallery', 'default', array(), 'error');
				$this->redirect('/properties/sold');
			}

			$this->set('property', $property);

			if ($this->request->is('ajax')) {
				if (isset($this->request->data['mailing_list'])) {
					$this->set('name', 'mailing_list');
				} else if (isset($this->request->data['arrange_viewing'])) {
					$this->set('name', 'arrange_viewing');
				}
			}

			$branch_name = $property['Branch']['name'];
			$this->loadModel('SiteSettings.SiteSettingCategory');
			$site_setting_category = $this->SiteSettingCategory->find('first', array('conditions' => array('name' => $branch_name)));
			if (is_array($site_setting_category) && !empty($site_setting_category)) {
				$this->set('telephone', Configure::read('SiteSetting.' . strtolower($branch_name) . '_telephone'));
			} else {
				$this->set('telephone', $property['Branch']['phone']);
			}

			$this->set('available_viewing_slots', explode("\n", Configure::read('SiteSetting.available_viewing_slots')));
			$this->InjectContactForm->display(EV_CONTACT_FORM_ARRANGE_A_VIEWING, 'arrange_viewing');

			// Get available property types
			$this->Property->Behaviors->unload('MetaData.Meta');
			$propertyTypes = $this->Property->find('all', array(
				'fields' => array(
					'DISTINCT (Property.type) AS property_type',
				),
				'order' => array(
					'Property.type ASC'
				)
			));

			$propertyOptions = array();
			foreach ($propertyTypes as $type) {
				$propertyOptions[$type['Property']['property_type']] = $type['Property']['property_type'];
			}
			$this->set('propertyTypes', $propertyOptions);
			$priceRanges = array();
			foreach (explode("\r\n", Configure::read('SiteSetting.price_ranges')) as $range) {
				$priceRanges[$range] = $range;
			}
			$this->set('priceRanges', $priceRanges);
			$this->InjectContactForm->display(EV_CONTACT_FORM_MAILING_LIST, 'mailing_list');

			if ($this->request->is('ajax')) {
				$this->render('EvContactForm.Common/ajax-default', 'ajax');
			}

			$this->set('voteCookie', $this->Cookie->read('Property.Vote.' . $id));

			$this->set('isMobile', $this->RequestHandler->isMobile());

			$this->set('title_for_layout', implode(', ', array($property['Property']['street'], $property['Property']['locality'], $property['Property']['county'])) . ' | ' . Configure::read('SiteSetting.site_title'));
		}

		public function sold() {
			$allSoldProperties = $this->Property->find('all', array(
				'fields' => array('Property.date_moved_to_sstc'),
				'conditions' => array(
					'Property.web_status' => array(
						Property::STATUS_SSTC,
						Property::STATUS_SOLD,
						Property::STATUS_VEBRA_SSTC,
						Property::STATUS_VEBRA_SOLD,
					)
				),
				'order' => array('Property.date_moved_to_sstc' => 'DESC', 'Property.price' => 'DESC')
			));
			if (!empty($allSoldProperties)) { // if we've got some sold properties to show
				if (sizeof($allSoldProperties) < 100) { // if there haven't been 100 sold properties, get the oldest one we have
					$oldestProperty = array_pop($allSoldProperties);
					$oldestDate = $oldestProperty['Property']['date_moved_to_sstc'];
				} else {
					$oldestDate = $allSoldProperties[99]['Property']['date_moved_to_sstc']; // get the 100th highest price
				}
			} else { // no sold properties, but we still need a date
				$oldestDate = '1970-01-01';
			}

			$orderBy = array(
				'Property.date_moved_to_sstc' => 'DESC',
				'Property.price' => 'DESC'
			);
			$conditions = array(
				'Property.web_status' => array(
					Property::STATUS_SSTC,
					Property::STATUS_SOLD,
					Property::STATUS_VEBRA_SSTC,
					Property::STATUS_VEBRA_SOLD,
				),
				'Property.date_moved_to_sstc >=' => $oldestDate
			);

			$this->Paginator->settings = array(
				'limit' => 12,
				'order' => $orderBy,
				'conditions' => $conditions,
				'contain' => array(
					'Paragraph',
					'Image'
				)
			);
			$properties = $this->Paginator->paginate('Property');
			$rows = array_chunk($properties, ($this->RequestHandler->isMobile() ? 3 : 4)); // split the properties into rows of four (for the grid-view)
			$this->set('rows', $rows);

			$mapLocations = $this->Property->find('all', array(
				'order' => $orderBy,
				'conditions' => $conditions,
				'fields' => array(
					'Property.latitude',
					'Property.longitude',
				)
			));
			$this->set('mapLocations', $mapLocations);

			if ($soldPageId = Configure::read('SiteSetting.sold_gallery_page_id')) {
				$this->loadModel('Page');
				$page = $this->Page->findById($soldPageId);

				if ($page) {
					$this->set('data', $page);
				}
			}
		}

		public function setSort($sort) {
			$this->sort = $sort;
		}

		public function setDirection($direction) {
			$this->direction = $direction;
		}

		protected function _setFilterData() {
			// Ge tavailable property types
			$this->Property->Behaviors->unload('MetaData.Meta');
			$property_types = $this->Property->find('all', array(
				'fields' => array(
					'DISTINCT (Property.type) AS property_type',
				),
				'order' => array(
					'Property.type ASC'
				)
			));

			$property_options = array();
			foreach ($property_types as $type) {
				$property_options[$type['Property']['property_type']] = $type['Property']['property_type'];
			}

			$this->set('property_types', $property_options);
			$this->set('radiusOptions', $this->Property->getRadiusOptions());
			$this->set('min_prices', $this->Property->getMinPrices());
			$this->set('max_prices', $this->Property->getMaxPrices());
			$this->set('min_bedrooms', $this->Property->getMinBedrooms());
			$this->set('max_bedrooms', $this->Property->getMaxBedrooms());
		}

		protected function _buildFilterUrl(&$form) {
			$filter_url['controller'] = $this->request->params['controller'];
			$filter_url['action'] = $this->request->params['action'];

			// Unset anything we weren't expecting. Yeah, this is clever, you know it (Y)
			foreach (array_diff(array_keys($form), $this->_getAllowedFilters()) as $key) {
				unset($form[$key]);
			}

			// for each filter we will add a GET parameter for the generated url
			foreach ($form as $name => &$value) {
				if ($value) {
					switch ($name) {
						case 'area':
							if (isset($form['radius']) && $form['radius'] !== 'exact') {
								list($queryWord) = explode(',', $value); // everything up to the first comma, to catch things like walton, chesterfield when we want to look up 'walton' in the overrides
								if (in_array(strtolower($queryWord), array_keys(Property::$locationOverrides))) {
									$filter_url['latitude'] = Property::$locationOverrides[$queryWord]['lat'];
									$filter_url['longitude'] = Property::$locationOverrides[$queryWord]['lng'];
								} else {
									$patterns = array(
										'/(^|\s|,)chesterfield\s?,?\s?/i',
										'/(^|\s|,)derbyshire\s?,?\s?/i',
										'/(\s|,)(uk\s|united\skingdom)\s?,?\s?/i',
										'/(\s|,)(england|gb|(great)?\sbritain)\s?,?\s?/i', // strip england / britain
										'/,\s?$/' // get rid of a trailing comma
									);
									$cleansedSearch = ucwords(trim(preg_replace($patterns, '', $value)));
									$value = $cleansedSearch . ($cleansedSearch !== '' ? ', ' : '') . 'Chesterfield, Derbyshire';
									$url = 'http://maps.google.com/maps/api/geocode/json?address=' . urlencode($value) . '&sensor=false&region=UK';
									$response = json_decode(file_get_contents($url), true);
									$filter_url['latitude'] = $response['results'][0]['geometry']['location']['lat'];
									$filter_url['longitude'] = $response['results'][0]['geometry']['location']['lng'];
								}
							} else {

							}
							$filter_url[$name] = $value;
							break;

						default:
							$filter_url[$name] = $value;
							break;
					}
				}
			}
			return $filter_url;
		}

		protected function _buildConditions(&$form, $strict = false) {
			$conditions = array();
			$has_min_price = $has_max_price = $has_min_bedrooms = $has_max_bedrooms = false;

			$conditions['Property.solddate'] = null; // we only ever want the unsold properties
			$conditions['NOT']['Property.web_status'] = array(Property::STATUS_SOLD, Property::STATUS_VEBRA_SOLD); // ignore sold states (but include SSTC)
			$conditions['Property.show_in_main_listings'] = true; // must be set to show in main listings
			$distance_query = ''
					. '('
					. '('
					. 'ACOS('
					. 'SIN(@latitude * PI() / 180) '
					. '* SIN(`Property`.latitude * PI() / 180) '
					. '+ COS(@latitude * PI() / 180) '
					. '* COS(`Property`.latitude * PI() / 180) '
					. '* COS((@longitude - `Property`.longitude) * PI() / 180)'
					. ') '
					. '* 180 / PI()'
					. ') '
					. '* 60 '
					. '* 1.1515'
					. ')'; // this looks scary (and unless you're awesome at maths, it's meant to), but it's just trying to figure out the distanec between two lat/long pairs
			foreach ($this->params['named'] as $param_name => $value) {
				if (!in_array($param_name, array('page', 'limit'))) { // Don't apply the default named parameters used for pagination
					// Build the query conditions
					switch ($param_name) {
						case 'latitude':
							$distance_query = str_replace('@latitude', $value, $distance_query);
							break;

						case 'longitude':
							$distance_query = str_replace('@longitude', $value, $distance_query);
							break;

						case 'min_price':
							$has_min_price = true;
							break;

						case 'max_price':
							$has_max_price = true;
							break;

						case 'min_bedrooms':
							$has_min_bedrooms = true;
							break;

						case 'max_bedrooms':
							$has_max_bedrooms = true;
							break;

						case 'area':
						case 'radius':
							// do nothing with it, just make sure we don't try to query it, as it's pretty much there to look nice and pre-populate the forms
							break;

						case 'sort':
							$this->setSort(urldecode($value));
							break;

						case 'direction':
							$this->setDirection(urldecode($value));
							break;

						case 'type':
							switch (strtolower($value)) { // to lower it just for consistency, in case they're in a weird format
								case 'house':
									$conditions[$param_name] = array(
										'House',
										'House - detached',
										'House - semi-detached',
										'House - terraced',
										'House - townhouse'
									);
									break;

								case 'apartment':
								case 'flat':
									$conditions[$param_name] = array(
										'Apartment',
										'Apartment - studio',
										'Flat'
									);
									break;

								default:
									$conditions[$param_name] = urldecode($value);
									break;
							}
							break;

						default: // by default we do a simple col = val
							$conditions[$param_name] = urldecode($value);
							break;
					}

					// Repopulate the form
					// We need to do a separate switch, because the overwhelming majority of values can remain as they are in the URL when being used in the form
					switch ($param_name) {
						default:
							$form[$param_name] = $value;
							break;
					}
				}
			}

			// Build distance conditions based on lat / long yielded from autocomplete area search
			if (!isset($this->params['named']['radius']) || $this->params['named']['radius'] !== 'exact') { // if there's no radius set, or it's not 'exact' we can do a lat long search
				if (isset($this->params['named']['latitude']) && isset($this->params['named']['longitude'])) {
					if (is_numeric($this->params['named']['latitude']) && is_numeric($this->params['named']['longitude'])) {
						$radius = (isset($this->params['named']['radius']) ? $this->params['named']['radius'] : static::SEARCH_RADIUS); // miles
						$conditions[$distance_query . ' <'] = $radius;
					}
				}
			} else if (isset($this->params['named']['radius']) && $this->params['named']['radius'] === 'exact') { // radius is set and is exact, so perform a LIKE match
				if (isset($this->params['named']['area'])) { // we need an area to do an exact location match
					if ($strict) { // if we're trying a strict match, make a query string out of the remaining words (after stop words have been removed)
						foreach (Property::$queryColumns as $column) {
							list($queryString) = explode(',', strtolower($this->params['named']['area']));
							$conditions['OR']['Property.' . $column] = $queryString;
						}
					} else {
						$stopwords = $this->Property->getStopwords();
						$searchedWords = explode(' ', str_replace(array(', ', ' - ', '. ', ',', '-', '.', ' '), ' ', strtolower($this->params['named']['area'])));
						$queryWords = array_diff($searchedWords, $stopwords);
						if (count($queryWords) > 1 && in_array('chesterfield', $queryWords)) { // if there's more than 1 word queried, and one of those words was chesterfield, then remove it
							unset($queryWords[array_search('chesterfield', $queryWords)]);
						}
						foreach ($queryWords as $key => $word) {
							foreach (Property::$queryColumns as $column) {
								$conditions['OR'][$key]['OR']['Property.' . $column . ' LIKE'] = '%' . $word . '%';
							}
						}
					}
				}
			}

			// Build price conditions
			if ($has_min_price && $has_max_price) {
				$conditions['Property.price BETWEEN ? AND ?'] = array($this->params['named']['min_price'], $this->params['named']['max_price']);
			} else if ($has_min_price) {
				$conditions['Property.price >='] = $this->params['named']['min_price'];
			} else if ($has_max_price) {
				$conditions['Property.price <='] = $this->params['named']['max_price'];
			}

			// Build bedroom conditions
			if ($has_min_bedrooms && $has_max_bedrooms) {
				$conditions['Property.bedrooms BETWEEN ? AND ?'] = array($this->params['named']['min_bedrooms'], $this->params['named']['max_bedrooms']);
			} else if ($has_min_bedrooms) {
				$conditions['Property.bedrooms >='] = $this->params['named']['min_bedrooms'];
			} else if ($has_max_bedrooms) {
				$conditions['Property.bedrooms <='] = $this->params['named']['max_bedrooms'];
			}
			return $conditions;
		}

		protected function _adminFormFields() {
			return array(); // we don't want any of the property information to be user-editable because it'll just get overwritten by the API, anyway
		}

		protected function _getAllowedFilters() {
			return $this->allowedFilters;
		}

	}
