<?php

	/*
	 * To change this license header, choose License Headers in Project Properties.
	 * To change this template file, choose Tools | Templates
	 * and open the template in the editor.
	 */

	/**
	 * Description of VebraImportShell
	 *
	 * @author Luke
	 */
	class VebraImportShell extends AppShell {

		public $uses = array('Vebra.Branch', 'Vebra.Property', 'Vebra.Paragraph', 'EvCore.Image');

		public function main() {
			// Change settings for file uploads to avoid potential issues
			ini_set('upload_max_filesize', '5M');
			ini_set('max_file_uploads', '5000');

			// Import the branches
			$this->dispatchShell('vebra_import import_branches');

			// For each branch now stored in the database, get it's properties
			foreach ($this->Branch->find('all') as $branch) {
				$this->dispatchShell('vebra_import import_properties ' . $branch['Branch']['id']);
			}
		}

		public function import_branches() {
			$added = $updated = $affected = $failed = 0;
			foreach ($this->Branch->getVebraBranches() as $branch) {
				try {
					$existing_branch = $this->Branch->find('first', array('conditions' => array('Branch.id' => $branch['id'])));
					if ($existing_branch) {
						$this->Branch->set('id', $existing_branch['Branch']['id']);
						$updated++;
					} else {
						$this->Branch->create();
						$added++;
					}
					$this->Branch->save($branch);
					$affected++;
				} catch (Exception $e) {
					$failed++;
					$affected++;
					$this->out('<error>' . $e->getMessage() . '</error>');
				}
			}
			$this->out("$affected affected ($added added, $updated updated, $failed failed)");
		}

		public function import_properties() {
			$added = $updated = $affected = $failed = 0;
			if (isset($this->args[0])) {
				$branch_id = $this->args[0];
				$properties = $this->Property->getVebraProperties($branch_id);
				if (!empty($properties)) {
					foreach ($properties as $property) {
						try {
							$existing_property = $this->Property->find('first', array('conditions' => array('Property.id' => $property['Property']['id'])));
							if ($existing_property) {
								$property['Property']['id'] = $existing_property['Property']['id']; // this doesn't make much difference, as property id will be the same as the existing property id
								$this->Image->deleteAll(array(
									'model' => 'Property',
									'model_id' => $property['Property']['id']
								)); // delete all images if we already have the property (so that they can be re-imported)
								$this->Paragraph->deleteAll(array(
									'property_id' => $property['Property']['id']
								)); // delete all paragraphs if we already have the property (so that they can be re-imported)
								$updated++;
							} else {
								$this->Property->create();
								$added++;
							}

							// Save properties
							$this->Property->saveAssociated($property);

							// Create the blurred image - this doesn't need to work with saving associated, and happens afterwards. It also takes ages, so be patient
							$imageParams = array(
								'conditions' => array(
									'model' => 'Property',
									'model_id' => $property['Property']['id']
								),
								'order' => 'sequence ASC',
								'limit' => 1
							);
							$image = $this->Image->find('first', $imageParams);
							if ($image) { // if we actually have a 'first' image to blur
								$this->Property->createBlurredImage($image['Image'], $property['Property']['id']);
							}
							$affected++;
						} catch (Exception $e) {
							$failed++;
							$affected++;
							$this->out('<error>' . $e->getMessage() . '</error>');
						}
					}
				}
			} else {
				$this->out('<error>No branch ID specified when attemtping to import properties</error>');
			}
			$this->out("$affected affected ($added added, $updated updated, $failed failed)");
		}

		/**
		 * Import all updated properties. The process is this:
		 * - Import and format all property data into a Cake-readable array from Vebra
		 * - Save all images to a temp directory
		 * - Delete all existing data for a property, such as images and paragraphs (this should by default also delete all associated files)
		 * - Save associated, which resaves all the data - including the newly-imported images
		 * - Create a blurred image from the first image imported for the current property
		 *
		 * If any of the above isn't happening, is happening in the wrong order, or errors, then something is probably broken and may have changed within the API itself
		 */
		public function import_updated_properties() {
			$updatedProperties = $this->Property->getVebraUpdatedProperties();

			$added = $updated = $deleted = $affected = $failed = 0;
			if (!empty($updatedProperties)) {
				foreach ($updatedProperties as $property) {
					try {
						if (!isset($property['action'])) {
							$property['action'] = ''; // let the switch fall to it's default action (probably an add if no action is set)
						}
						switch ($property['action']) {
							case 'deleted':
								// The property is actually deleted in the Vebra model, but it may be sensible to move this functionality into here at some point
								$deleted++;
								break;

							case 'updated':
							default:
								$existing_property = $this->Property->find('first', array('conditions' => array('Property.id' => $property['Property']['id'])));
								if ($existing_property) {
									$property['Property']['id'] = $existing_property['Property']['id']; // this doesn't make much difference, as property id will be the same as the existing property id
									$this->Image->deleteAll(array(
										'model' => 'Property',
										'model_id' => $property['Property']['id']
									)); // delete all images if we already have the property (so that they can be re-imported)
									$this->Paragraph->deleteAll(array(
										'property_id' => $property['Property']['id']
									)); // delete all paragraphs if we already have the property (so that they can be re-imported)
									$updated++;
								} else {
									$this->Property->create();
									$added++;
								}

								// Save properties
								$this->Property->saveAssociated($property);

								// Create the blurred image - this doesn't need to work with saving associated, and happens afterwards. It also takes ages, so be patient
								$imageParams = array(
									'conditions' => array(
										'model' => 'Property',
										'model_id' => $property['Property']['id']
									),
									'order' => 'sequence ASC',
									'limit' => 1
								);
								$image = $this->Image->find('first', $imageParams);
								if ($image) { // provided we have a 'first' image to work with
									$this->Property->createBlurredImage($image['Image'], $property['Property']['id']);
								}
								break;
						}

						$affected++;
					} catch (Exception $e) {
						$affected++;
						$failed++;
						$this->out('<error>' . $e->getMessage() . '</error>');
					}
				}
			}
			$this->out("$affected affected ($added added, $updated updated, $deleted deleted, $failed failed)");
		}

		public function get_property_details() {
			if (!isset($this->args[0]) || !isset($this->args[1])) {
				$this->out('<error>You must specify a branch and property ID in order to retrieve it\'s details</error>');
			} else {
				$branchId = $this->args[0];
				$propertyId = $this->args[1];
				$this->out('<info>Property details found:</info>');
				$this->out('<comment>Note any DEBUG_ fields are added manually to demonstrate one of a particular import item</comment>');
				$this->out('<comment>We log one regular image and one "special" image (i.e. a particular floorplan type)</comment>');
				$property = $this->Property->getVebraProperty($branchId, $propertyId);

				// Get rid of all the superfluous data. In future we should really add flags so that we can control which data to show
				$images = null;
				if (isset($property['files'])) {
					$images[] = $property['files']['file'][0];
					foreach ($property['files']['file'] as $file) {
						if (preg_match('/(detail|street|town)/', $file['name'])) { // we log a special type of floorplan image, as these are handled differently to other images and are most likely to fail
							$images[] = $file;
							break;
						}
					}
					unset($property['files']);
				}

				$paragraph = null;
				if (isset($property['paragraphs']['paragraph'][0])) {
					$paragraph = $property['paragraphs']['paragraph'][0];
				}
				unset($property['paragraphs']);

				$bullet = null;
				if (isset($property['bullets']['bullet'][0])) {
					$bullet = $property['bullets']['bullet'][0];
				}
				unset($property['bullets']);

				unset($property['hip']);
				unset($property['area']);

				$property['DEBUG_SampleImage'] = $images;
				$property['DEBUG_SamplePara'] = $paragraph;
				$property['DEBUG_SampleBullet'] = $bullet;
				$this->out(print_r($property, true));
			}
		}

	}
