<?php

App::uses('AppHelper', 'View/Helper');

class TwitterEmbedHelper extends AppHelper {

/**
 * Default Constructor. Redefined to add additional helpers.
 *
 * @param View $View The View this helper is being attached to.
 *
 * @param array $settings Configuration settings for the helper.
 */
	public function __construct(View $View, $settings = []) {
		$this->helpers[] = 'Html';

		parent::__construct($View, $settings);
	}

/**
 * Output date correctly
 *
 * @param string $pageContent The page html
 *
 * @return string The page html
 */
	public function parse($pageContent) {
		$search = '/\[twitter\=(.*?)(\s.*?)?\]/';

		preg_match_all($search, $pageContent, $twitterFeeds);

		if (!empty($twitterFeeds)) {
			$allowedAttributes = [
				'width' => 'data-width',
				'height' => 'data-height',
				'theme' => 'data-theme',
				'link-colour' => 'data-link-color',
				'dnt' => 'data-dnt',
			];

			$find = [];
			$replace = [];

			foreach ($twitterFeeds[0] as $key => $fullRequest) {
				$feed = !empty($twitterFeeds[1][$key]) ? $this->_cleanTwitterString($twitterFeeds[1][$key]) : null;
				if (!empty($feed)) {
					$attributes = ' ';

					if (!empty($twitterFeeds[2][$key])) {
						$commandString = $this->_cleanTwitterString($twitterFeeds[2][$key]);

						$commands = explode(' ', $commandString);
						foreach ($commands as $command) {
							list($attribute, $value) = explode('=', $command, 2);

							if (!empty($attribute) && !empty($value) && array_key_exists($attribute, $allowedAttributes)) {
								$attributes .= $allowedAttributes[$attribute] . '="' . $value . '" ';
							}
						}
					}

					$find[] = $fullRequest;
					$replace[] = '<a class="twitter-timeline" href="https://twitter.com/' . $feed . '"' . rtrim($attributes) . '>Tweets by ' . $feed . '</a>';
				}
			}

			$pageContent = str_replace($find, $replace, $pageContent);

			$pageContent .= $this->Html->script('https://platform.twitter.com/widgets.js', ['async', 'charset' => 'utf-8']);
		}

		return $pageContent;
	}

/**
 * Trim the string and remove extra spaces
 *
 * @param string $string The string to replace
 *
 * @return string
 */
	protected function _cleanTwitterString($string) {
		return trim(preg_replace(['/\&nbsp\;/', '/\s+/'], ' ', $string));
	}
}
