<?php

App::uses('Twitter', 'EvTwitter.Utility');
App::uses('CakeTime', 'Utility');

class TwitterFeed extends EvTwitterAppModel {

	public $primaryKey = 'tweet_id';

	public $displayField = 'tweet';
	
	public $belongsTo = array(
		'TwitterConnection' => array(
			'className' => 'EvTwitter.TwitterConnection'
		)
	);

	public function __construct($id = false, $table = null, $ds = null) {

		parent::__construct($id, $table, $ds);

		$this->TwitterConnection = ClassRegistry::init('EvTwitter.TwitterConnection');

	}

	public function getFeed($limit=10, $conditions=array()) {

		$credentials = $this->TwitterConnection->find('first', $conditions);

		$Twitter = new Twitter($credentials['TwitterConnection']['token'], $credentials['TwitterConnection']['secret']);

		$check = empty($credentials['TwitterConnection']['last_checked']) || !CakeTime::wasWithinLast('5 hours', $credentials['TwitterConnection']['last_checked']);

		if ($check === true) {

			$response = $Twitter->get('statuses/user_timeline');
			$response = array_slice($response, 0, $limit);

			$data = array();

			foreach ($response as $row) {

				$data[] = array(
					'twitter_connection_id' => $credentials['TwitterConnection']['id'],
					'tweet_id' => $row->id_str,
					'tweet' => $row->text,
					'post_date' => CakeTime::format('Y-m-d H:i:s', strtotime($row->created_at))
				);

			}

			$this->saveMany($data);

			// Update the last checked date on the credentials.
			$this->TwitterConnection->id = $credentials['TwitterConnection']['id'];
			$this->TwitterConnection->saveField('last_checked', gmdate('Y-m-d H:i:s'));

		}

		$data = $this->find('all', array(
			'order' => array(
				$this->escapeField('post_date') => 'DESC'
			),
			'limit' => $limit
		));

		return $data;

	}

}