<?php

App::uses('TwitterTweet', 'EvTwitter.Model');
App::uses('EvTwitterAppModel', 'EvTwitter.Model');

class TwitterConnection extends EvTwitterAppModel {
	
	public $hasMany = array(
		'TwitterFeed' => array(
			'className' => 'EvTwitter.TwitterFeed',
			'cascade' => true,
			'dependent' => true
		)
	);

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'token';


/**
 *  Runs before delete
 *  - Deletes all tweets
 */
	public function beforeDelete($cascade = true) {
		// Delete tweets
		$this->TwitterTweet = new TwitterTweet();
		$this->TwitterTweet->deleteAll();

		return true;
	}

/**
 * Method to check whether a site has set up thier OAUTH twitter details
 * @return (boolean) - Returns true if the user id is set
 */
	public function isTwitterSetup($model=NULL, $modelID=NULL) {

		return $this->find('first', array('conditions'=>array('model'=>$model, 'model_id'=>$modelID))) != false;
		
	}

}
