<?php

App::uses('EvTwitterAppController', 'EvTwitter.Controller');
App::uses('Twitter', 'EvTwitter.Utility');

class TwitterConnectController extends EvTwitterAppController {

	public $uses = 'EvTwitter.TwitterConnection';

	public function beforeFilter() {

		$this->adminActions[] = 'admin_twitter';
		$this->adminActions[] = 'admin_clear';

		return parent::beforeFilter();
	}

/**
 * Manages a default admin index view of this model
 * Includes a filter form and paginated results
 *
 * @param string $model: The Model
 * @param int $modelID: the ID of the item we're connecting up
 *
 *  @return void
 */
	public function admin_index($model=NULL, $modelID=NULL) {
		
		if ($this->TwitterConnection->isTwitterSetup($model, $modelID)) {

			$this->Session->setFlash('This item is already connected to Twitter', 'flash_success');

		} else {

			$Twitter = new Twitter();

			$temporaryCredentials = $Twitter->getRequestToken(Router::url(array('action' => 'twitter'), true));
			$temporaryCredentials['model'] = $model;
			$temporaryCredentials['model_id'] = $modelID;

			$this->Session->write('EvTwitter.tmp', $temporaryCredentials);
			$this->Session->write('EvTwitter.referer', $this->referer());

			$this->redirect($Twitter->getAuthorizeURL($temporaryCredentials));

			return;

		}

		return $this->redirect($this->referer());
	}

/**
 * Callback function for twitter once it has connected a user to the app
 * Saves the users OAuth details and redirects them back to the admin_index
 */
	public function admin_twitter() {

		if (isset($this->params->query['denied'])) {
			$this->Session->setFlash('Failed to connect app to twitter', 'flash_fail');
			return $this->redirect(array('controller' => $controller, 'action' => 'view', 'plugin' => $plugin));
		}

		$temporaryCredentials = $this->Session->read('EvTwitter.tmp');
		$modelData = $this->Session->read('EvTwitter.item');

		$Twitter = new Twitter(
			$temporaryCredentials['oauth_token'],
			$temporaryCredentials['oauth_token_secret']
		);

		$tokenCredentials = $Twitter->getAccessToken($_REQUEST['oauth_verifier']);

		$data = array(
			'model' => $temporaryCredentials['model'],
			'model_id' => $temporaryCredentials['model_id'],
			'token' => $tokenCredentials['oauth_token'],
			'secret' => $tokenCredentials['oauth_token_secret'],
		);

		$this->TwitterConnection->create();
		$this->TwitterConnection->save($data);

		$this->Session->setFlash('You have successfully connected to Twitter', 'flash_success');
		return $this->redirect($this->Session->read('EvTwitter.referer'));

	}

/**
 * Function to disassociate a site with Twitter
 * Deleting TwitterOauth record and all tweets
 * @param $id - Site ID
 */
	public function admin_clear($id) {

		//Get twitter Oauth row
		$oauth = $this->TwitterConnection->find('first', array('conditions'=>array('id'=>$id)));
		if ($oauth) {
			$this->TwitterConnection->delete($oauth['TwitterConnection']['id']);
			$this->Session->setFlash('You have successfully unlinked this item from Twitter', 'flash_success');
			return $this->redirect(array('controller'=>'site_settings', 'action'=>'index', 'plugin' => false));
		} else {
			$this->Session->setFlash('This item is not currently linked to Twitter. ', 'flash_fail');
			return $this->redirect(array('controller'=>'site_settings', 'action'=>'index', 'plugin' => false));
		}
	}

}