<div class="content__container">

    <div>

        <div style="display:inline-block; text-align:left; width:70%;">
            <h1 class="title">Translation Languages <span>Administration</span></h1>
            <h2 class="title">Manage Translated Phrases (Group: <?php echo $group['TranslationPhraseGroup']['name']; ?>)</h2>
        </div>
        <div style="display:inline-block; text-align:right; width:auto;">
            <a href="/admin/ev_translation/translation_languages/edit/<?php echo $language_id; ?>" class="btn"><i class="fa fa-caret-left"></i> Back To Language Phrase Groups</a>
        </div>
    </div>

    </div>

    <br>

    <table class="table">
        <thead>
            <tr>
                <th>Original Phrase / Field Info</th>
                <th>Current Translation</th>
                <th width="5%">Edit</th>
                <th width="5%">Delete</th>
            </tr>
        </thead>
        <tbody>
            <?php if(!empty($phrases)): ?>
                <?php foreach($phrases as $phrase): ?>
                    <?php
                    if(isset($phrase['TranslationTranslation'][0]['translation'])):
                        $translation = $phrase['TranslationTranslation'][0]['translation'];
                    elseif(isset($phrase['TranslationPhrase']['original_string'])):
                        $translation = $phrase['TranslationPhrase']['original_string'];
                    else:
                        $translation = ' - ';
                    endif;
                    ?>
                    <tr>
                        <td><?php echo $this->Text->truncate(strip_tags($phrase['TranslationPhrase']['default_value']), 50); ?></td>
                        <td><?php echo $this->Text->truncate(strip_tags($translation), 50); ?></td>
                        <td><a href="/admin/ev_translation/translation_translations/edit_translation/<?php echo $language_id; ?>/<?php echo $phrase['TranslationPhrase']['id']; ?>/<?php echo (isset($phrase['TranslationTranslation'][0]['id']) ? $phrase['TranslationTranslation'][0]['id'] : ''); ?>"><i class="s s--edit"></i></a></td>
                        <td><a href="/admin/ev_translation/translation_translations/delete_translation/<?php echo $language_id; ?>/<?php echo $phrase['TranslationPhrase']['id']; ?>/<?php echo (isset($phrase['TranslationTranslation'][0]['id']) ? $phrase['TranslationTranslation'][0]['id'] : ''); ?>"><i class="s s--delete"></i></a></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4" class="text-center">This group has no phrases to translate.</td>
                </tr>
            <?php endif; ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="4" class="text-right">
                    <a href="/admin/ev_translation/translation_languages/edit/<?php echo $language_id; ?>" class="btn"><i class="fa fa-caret-left"></i> Back To Language Phrase Groups</a>
                </th>
            </tr>
        </tfoot>
    </table>
    <div clas="container-fluid">
        <div class="row">
            <div class="col-xs-12 text-center">
                <?php echo $this->Element('index_paginate'); ?>
            </div>
        </div>
    </div>

</div>
<?php echo $this->Html->css('EvTranslation.admin_style'); ?>