<?php
App::uses('AppHelper', 'View/Helper');
App::uses('TranslationUtil', 'EvTranslation.Lib');

class TranslationHelper extends AppHelper {

    /**
     * magic method to check if the function exists in the lib file and call it if so
     * if not, it will try and return the string we were trying to Inflect
     * if it can't do that, it will just return false
     *
     */
    public function __call($name, $arguments)
    {
        if (method_exists('TranslationUtil', $name)) {

            return call_user_func_array('TranslationUtil::' . $name, $arguments);
        }

        // we can't find it, return false
        return false;
    }
}