<?php
App::uses('AppModel', 'Model');
/**
 * TranslationPhrase Model
 *
 * @property TranslationPhraseGroup $TranslationPhraseGroup
 * @property TranslationTranslation $TranslationTranslation
 */
class TranslationPhrase extends AppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'custom_slug';

	public $cacheQueries = true;

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'TranslationPhraseGroup' => array(
			'className' => 'EvTranslation.TranslationPhraseGroup',
			'foreignKey' => 'translation_phrase_group_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'TranslationTranslation' => array(
			'className' => 'EvTranslation.TranslationTranslation',
			'foreignKey' => 'translation_phrase_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

	public function defaultPhraseValues()
	{

		$data = array();

		$phrases = $this->find('all', array(
			'conditions' => array(
				'is_active' => '1'
			)
		));

		foreach ($phrases as $phrase) {

			if (isset($phrase['TranslationPhrase']['custom_slug']) && $phrase['TranslationPhrase']['custom_slug'] !='') {
				$data[$phrase['TranslationPhrase']['custom_slug']] = $phrase['TranslationPhrase']['default_value'];
			}

		}

		return $data;

	}

	public function cleanData() {

		// Load up all model based translation phrases
		$data = $this->find('all', array(
			'conditions' => array(
				'model !=' => '',
				'model_id !=' => '',
				'model_field !=' => ''
			),
			'contain' => array(
				'TranslationTranslation'
			)
		));

		$phrase_ids = array();
		$translation_ids = array();

		foreach ($data as $phrase) {

			if (empty($phrase['TranslationTranslation'])) {
				//pr($phrase);die();
				// Phrase isnt in use. Add it to the delete list.
				$phrase_ids[] = $phrase['TranslationPhrase']['id'];
				echo 'DELETE PHRASE ID '.$phrase['TranslationPhrase']['id'];
				$this->delete($phrase['TranslationPhrase']['id']);
				echo' ... DONE<br>';;
			}
		}
		die();
		if (!empty($phrase_ids)) {
			//return $this->deleteAll($phrase_ids);
		}
		return false;
	}
}
