<?php
App::uses('AppModel', 'Model');
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');

/**
 * TranslationLanguage Model
 *
 * @property TranslationTranslation $TranslationTranslation
 */
class TranslationLanguage extends AppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'language';

	public $cacheQueries = true;

/**
 * Flag image field
 * Using flags to represent countries is a bad practice - avoid it if at all possible but
 * this is here for those sites that do need it.
 *
 * @var string
 */
	public $imageSlots = array(
        'flag' => array(
            'slots' => 1,
            'fields' => array(
                'alt'
            )
        )
    );

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'language' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => 'A language name must be provided.',
			),
		),
		'locale' => array(
			'required' => array(
				'rule' => 'notEmpty',
				'message' => "The locale for the language must be set as a valid IETF language tag. Examples of this would be: en-GB, en-US and fr-BE",
			),
		),
	);

	/**
	 * hasMany associations
	 *
	 * @var array
	 */
	public $hasMany = array(
		'TranslationTranslation' => array(
			'className' => 'EvTranslation.TranslationTranslation',
			'foreignKey' => 'translation_language_id',
			'dependent' => false,
		)
	);

	public function readForEdit($id, $query = array())
	{

		return parent::readForEdit($id, $query);
	}

	public function loadDefaultLanguage()
	{

		if(Configure::read('EvTranslation.language_id') !='') {

			$lang = $this->find('first', array(
				'conditions' => array(
					'id' => Configure::read('EvTranslation.language_id')
				)
			));

		} else {

			$lang = $this->find('first', array(
				'conditions' => array(
					'is_default' => '1'
				)
			));
		}

		if (!empty($lang)) {

			return $this->loadLanguage($lang['TranslationLanguage']['id']);
		}

		return false;
	}

	public function loadLanguage($id)
	{

		$lang = $this->find('first', array(
			'conditions' => array(
				'id' => $id,
				'is_active' => '1'
			),
			'contain' => array(
				'TranslationTranslation'
			)
		));

		$results = Hash::extract($lang, 'TranslationTranslation.{n}.translation_phrase_id');

		$phraseModel = ClassRegistry::init('EvTranslation.TranslationPhrase');
		$phrases = $phraseModel->find('all', array(
			'conditions' => array(
				'TranslationPhrase.id' => $results
			),
			'contain' => array(
				'TranslationPhraseGroup'
			)

		));

		$phrases = Hash::combine($phrases, "{n}.TranslationPhrase.id", "{n}");

		if (isset($lang['TranslationTranslation'])) {

			foreach ($lang['TranslationTranslation'] as $key => $translation) {

				$lang['TranslationTranslation'][$key]['TranslationPhrase'] = $phrases[$translation['translation_phrase_id']]['TranslationPhrase'];
				$lang['TranslationTranslation'][$key]['TranslationPhrase']['TranslationPhraseGroup'] = $phrases[$translation['translation_phrase_id']]['TranslationPhraseGroup'];
			}
		}

		$phrases = array();

		if (isset($lang['TranslationTranslation'])) {

			foreach ($lang['TranslationTranslation'] as $translation) {

				if (isset($translation['TranslationPhrase']) && (!isset($translation['TranslationPhrase']['custom_slug']) || $translation['TranslationPhrase']['custom_slug'] == '')) {

					$phrases[$translation['TranslationPhrase']['model'].'_'.$translation['TranslationPhrase']['model_id'].'_'.$translation['TranslationPhrase']['model_field']] = $translation['translation'];

				} else {

					if ($translation['translation'] && isset($translation['TranslationPhrase'])) {

						$phrases[$translation['TranslationPhrase']['custom_slug']] = $translation['translation'];

					} else {
						if (isset($translation['TranslationPhrase'])) {
							$phrases[$translation['TranslationPhrase']['custom_slug']] = $translation['TranslationPhrase']['default_value'];
						}
					}
				}
			}
		}

		// Load any non-translated strings and use their default values.
		$this->TranslationPhrase = ClassRegistry::init('TranslationPhrase');

		$lang = $this->TranslationPhrase->find('all', array(
			'conditions' => array(
				'is_active' => '1'
			)
		));

		foreach ($lang as $phrase) {

			if (empty($phrase['TranslationPhrase']['custom_slug'])) {

				$phrase_slug = $phrase['TranslationPhrase']['model'] . '_' . $phrase['TranslationPhrase']['model_id'] . '_' . $phrase['TranslationPhrase']['model_field'];

				if (!isset($phrases[$phrase_slug])) {
					$phrases[$phrase_slug] = $phrase['TranslationPhrase']['default_value'];
				}

			} else {

				if (!isset($phrases[$phrase['TranslationPhrase']['custom_slug']])) {
					$phrases[$phrase['TranslationPhrase']['custom_slug']] = $phrase['TranslationPhrase']['default_value'];
				}

			}

		}
		return $phrases;
	}


}
