#Usage

To use the translation system you have two methods - both of which can be used together or independantly.

Because the plugin supports both per-plugin translations and manually created slug based translations, when you're working within a plugin that's been set to use translations, all the translation data would have been loaded.

However there may be situations where you're working on a section that hasn't got translations enabled on a plugin, but you still need access to manually created translation slugs.

To enable this, all you need to do is open your AppController file, and in your beforeFilter method, add the translation helper. 

Here's an example of this:

<pre>public function beforeFilter()
{
    parent::beforeFilter();

    $this->helpers[] = 'EvTranslation.Translation';
}</pre>

This'll make slugs globally available via your views, and they can be called like so:

<pre>echo $this->Translation->lang('your_unique_slug');</pre>

##Integration with existing models
If you'd like to automatically enable translation support on your models (be it ones for your individual project, or ones part of another plugin such as the blog) you'll needto make a few minor modifications.

The first thing you'll want to do is modify your <code>$actAs</code> array to include the translations. This should look something like this:

<pre>public $actsAs = array(
    'EvTranslation.Translatable' => array(
        'excluded_fields' => array(
            'input_type',
        )
    )
);</pre>

Notice the excluded_fields array - using this you can exclude certain table fields from translation. You won't need to add any integer or date fields as these are automatically excluded.

Next you'll need to open your controller up. In here you'll need to make a few more changes. You'll need to load the translation component inside your beforeFilter method, then you'll need to assign the translation fields via the _adminFormFields() method, followed by creating a custom admin_edit method that loads a custom view up. This is what's used to inject the translations tab.

Inside the docs folder a copy of the standard Pages controller has been included with these modifications, along with a copy of it's admin_form.ctp file to demonstrate the changes you need to make.

Obviously if you're doing these changes to a plugin that you're using you'll need to extend that plugin instead of editing the main controller and view files.

The end result after this will be a new tab on your add/edit page. Initially no language options will be available - remember to go and create a new language at /admin/ev_translation/translation_languages/ first!

##Changing Languages

The plugin sets the lanuage id to use as default on the front end via its config file - this can be overriden like so:

<pre>Configure::write('EvTranslation.language_id, ID HERE);</pre>

I've intentionally not set any switching on languages as default as every site is going to be different in how it needs to handle switching languages - some will want to auto detect, some will want a simple switcher. It's at your discression how you decide to do this. All you'll need to do is run the above config change on each load.

In any situation where a language phrase can't be found, the system will try to revert to a backup language. If that's not found either, it'll either show the original content (if used on an existing model) or it'll show the slug (if it was a custom translation phrase).
