<?php
App::uses('AppController', 'Controller');


class TranslationLanguagesController extends AppController {

	public $components = array('RequestHandler');

	public function beforeFilter()
	{
		$this->adminActions[] = 'admin_add';

		parent::beforeFilter();

		$this->Auth->allow(array(
			'admin_index',
			'admin_edit',
			'admin_language',
			'admin_phrases',
			'admin_add'
		));
	}

	public function _adminIndexActions()
	{
		return array(
			'Edit',
			'Delete'
		);
	}

	public function _adminPopulateLookups()
	{
		parent::_adminPopulateLookups();

		if (Configure::read('EvTranslation.enable_ev_country_linking')) {

			$this->loadModel('EvCountry.Country');
			$countries = $this->Country->find('list');
			$this->set('countries', $countries);

		}
	}

	/**
	 * define the columns to show on the listing
	 */
	public function _adminIndexColumns()
	{
		return array(
			'TranslationLanguage.language' => array(
				'label' => 'Language',
				'type' => 'string'
			),
			'TranslationLanguage.created' => array(
				'label' => 'Submitted',
				'type' => 'datetime_nice'
			)
		);
	}

	public function _adminFormFields() {
		$fields = parent::_adminFormFields();

		// Add a sligtly more helpful description of the fields (TODO: Upgrade this to use Mike's new longer info field once its stable)
		$fields['TranslationLanguage.language']['info'] = 'This is the language name as it\'ll appear on all areas of the admin area and frontend.';
		$fields['TranslationLanguage.locale']['info'] = 'This is the IETF language tag for the specific language. This is generally formatted as two characters from the language, followed by a dash then two characters from thre primary region or country it applies to. For example British English is en-GB and American English is en-US.';
		$fields['TranslationLanguage.is_default']['info'] = 'Only one of your languages should be set to the default one.';

		return $fields;
	}

	public function admin_edit($id = null) {

		parent::admin_edit($id);

		$this->loadModel('EvTranslation.TranslationPhraseGroup');
		if($id) {

			$phrase_groups = $this->TranslationPhraseGroup->find('all', array(
				'contain' => array(
					'TranslationPhrase',
					'TranslationPhrase.TranslationTranslation' => array(
						'conditions' => array(
							'TranslationTranslation.translation_language_id' => $id
						)
					),
				)
			));

		} else {
			$phrase_groups = array();
		}

		$this->set('phrase_groups', $phrase_groups);
		$this->set('language_id', $id);

		$this->view = '../TranslationLanguages/admin_form';
	}

	public function admin_add()
	{
		return parent::admin_edit();
	}
}
