<?php
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');
App::uses('AppShell', 'Console/Command');

class TranslationCacheShell extends AppShell {

	public $uses = array(
		'EvTranslation.TranslationLanguage',
		'EvTranslation.TranslationPhrase',
		'EvTranslation.TranslationTranslation'
	);

	public function run() {
		$this->clear();
		$this->rebuild();
	}

	public function rebuild() {
		$cacheDir = TMP . DS . 'translation_cache' . DS;

		// Load langs
		$languages = $this->TranslationLanguage->find('all', array(
			'contain' => array(
				'TranslationTranslation'
			)
		));

		foreach ($languages as $language) {

			$langData = $this->TranslationLanguage->loadLanguage($language['TranslationLanguage']['id']);
			$langData = json_encode($langData);

			// Save!
			$filename = 'cache_' . $language['TranslationLanguage']['id'] . '.json';
			$file = new File($cacheDir . $filename);
			$file->write($langData);

			// If its the default, save a second copy (saves an extra query)
			if ($language['TranslationLanguage']['is_default'] == '1') {
				$filename = 'cache_default.json';
				$file = new File($cacheDir . $filename);
				$file->write($langData);
			}
		}



	}

	public function clear() {
		$cacheDir = TMP . DS . 'translation_cache' . DS;

		$folder = new Folder($cacheDir);
		$folderData = $folder->read();

		if (isset($folderData[1]) && ! empty($folderData[1])) {

			// Loop through and delete the files
			foreach ($folderData[1] as $filename) {
				$file = new File($cacheDir . $filename);
				$file->delete();
			}
		}
	}
}
