<?php
echo $this->Html->script('admin_scripts');
?>

<?php if(!empty($phrase_groups)): ?>
    <table class="table">
        <thead>
            <tr>
                <th>Phrase Group</th>
                <th>Total Phrases</th>
                <th>Total Translated</th>
                <th>Manage</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($phrase_groups as $group): ?>
                <?php
                $translated = 0;
                foreach($group['TranslationPhrase'] as $phrase):
                    if(count($phrase['TranslationTranslation']) > 0):
                        $translated = $translated + count($phrase['TranslationTranslation']);
                    endif;
                endforeach;
                ?>

                <tr>
                    <td><?php echo $group['TranslationPhraseGroup']['name']; ?></td>
                    <td><?php echo count($group['TranslationPhrase']); ?></td>
                    <td><?php echo $translated; ?></td>
                    <td><a href="/admin/ev_translation/translation_phrases/manage/<?php echo $group['TranslationPhraseGroup']['id']; ?>/<?php echo $language_id; ?>" class="btn btn-sm">Manage <i class="fa fa-caret-right"></i></a></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="4" class="text-right">
                    <a href="/admin/ev_translation/translation_languages">Back To Language Management</a>
                </th>
            </tr>
        </tfoot>
    </table>
<?php else: ?>
    <p style="text-align:center">There are no translation phrase groups to manage.</p>
<?php endif; ?>

<?php echo $this->Html->css('EvTranslation.admin_style'); ?>