<?php
App::uses('AppController', 'Controller');


class TranslationTranslationsController extends AppController {

    public $components = array('RequestHandler');

    public function beforeFilter()
    {

        $this->adminActions[] = 'admin_edit_translation';
        $this->adminActions[] = 'admin_add_translation';

        parent::beforeFilter();

    }

    public function _adminFormFields()
    {
        $fields = parent::_adminFormFields();
        $fields['TranslationTranslation.translation']['type'] = 'text_plain';

        return $fields;
    }

    public function _adminFormToolbar($id = null)
    {
        return array();
    }

    public function admin_edit_translation($language_id, $phrase_id, $id = null)
    {

        $Model = $this->{$this->modelClass};
        $modelAlias = $Model->alias;

        if (!empty($this->request->data)) {

            $this->request->data = $this->_processImages($this->request->data);

            if ($Model->saveAll($this->request->data, array('deep' => true))) {

                $action = ($id===null) ? 'created' : 'updated';
                $title = empty($this->data[$modelAlias][$Model->displayField]) ? InflectorExt::humanize($Model->displayName) : '&lsquo;' . $this->data[$modelAlias][$Model->displayField] . '&rsquo;';

                $this->Session->setFlash(array(
                    'title' => InflectorExt::humanize($Model->displayName) . " $action",
                    'description' => "$title has been successfully $action!"
                ), 'flash_success');

                if (isset($this->request->data['return']) && $this->request->data['return'] == 1) {

                    $this->Session->write("Admin.$modelAlias.return", true);

                    $return = array('action' => 'edit', $Model->id);

                } else {

                    $this->Session->delete("Admin.$modelAlias.return");

                    $redirect = $this->Session->read("Admin.$modelAlias.filter");
                    if (strpos($redirect, 'Filter') !== false) {
                        $return = $redirect;
                    }
                    else {
                        $return = array('action' => 'index');
                    }
                }

                $this->loadModel('TranslationPhrase');

                $phrase = $this->TranslationPhrase->find('first', array(
                    'conditions' => array(
                        'id' => $this->request->data['TranslationTranslation']['translation_phrase_id']
                    )
                ));

                $return = array(
                    'controller' => 'translation_phrases',
                    'action' => 'manage',
                    $phrase['TranslationPhrase']['translation_phrase_group_id'],
                    $language_id
                );

                return $this->redirect($return);

            } else {

                $this->Session->setFlash(array(
                    'title' => 'Save failed',
                    'description' => 'Failed to save ' . InflectorExt::humanize($Model->displayName) . ', see below for details'
                ), 'flash_fail');

            }

        } elseif ($id !== null) {

            $this->request->data = $Model->readForEdit($id);

            if (!$this->request->data) {

                throw new NotFoundException();

            }
            $this->Session->write("Admin.$modelAlias.filter", $this->referer());
        }

        $actionLabel = ($id===null) ? 'Add' : 'Edit';

        if (!isset($this->request->data['TranslationTranslation']['translation_language_id']) || $this->request->data['TranslationTranslation']['translation_language_id'] == '') {
            $this->request->data['TranslationTranslation']['translation_language_id'] = $language_id;
        }

        if (!isset($this->request->data['TranslationTranslation']['translation_phrase_id']) || $this->request->data['TranslationTranslation']['translation_phrase_id'] == '') {
            $this->request->data['TranslationTranslation']['translation_phrase_id'] = $phrase_id;
        }

        $fields = $this->_adminFormFields();
        $fields['TranslationTranslation.translation_language_id']['type'] = 'hidden';
        $fields['TranslationTranslation.translation_phrase_id']['type'] = 'hidden';

        // Get the original phrase to translate.
        $this->loadModel('TranslationPhrase');
        $phrase = $this->TranslationPhrase->find('first', array(
            'conditions' => array(
                'id' => $phrase_id
            )
        ));

        if($phrase['TranslationPhrase']['field_type'] == 'html') {
            $fields['TranslationTranslation.translation']['type'] = 'html';
        }

        // Use the stored phrase info to load up the original location model data
        if ($phrase['TranslationPhrase']['model'] !='') {
            $this->loadModel($phrase['TranslationPhrase']['model']);

            $model = $this->{$phrase['TranslationPhrase']['model']}->find('first', array(
                'conditions' => array(
                    'id' => $phrase['TranslationPhrase']['model_id']
                )

            ));

            $original_text = $model[$phrase['TranslationPhrase']['model']][$phrase['TranslationPhrase']['model_field']];
        } else {

            $original_text = $phrase['TranslationPhrase']['custom_slug'];

            if ($phrase['TranslationPhrase']['default_value'] !='') {
                $original_text = $phrase['TranslationPhrase']['default_value'];
            }

        }

        $this->set('original_text', $original_text);


        $this->set('title_for_layout', "$actionLabel " . InflectorExt::humanize($Model->displayName));
        $this->set('fields', $fields);
        $this->set('toolbar', $this->_adminFormToolbar($id));
        $this->set('blocks', $this->_adminFormBlockFields());
        $this->set('imageSlots', $Model->imageSlots);
        $this->set('documentSlots', $Model->documentSlots);
        $this->set('menuFields', $this->_adminFormMenuFields(isset($this->request->data['Menu']['id']) ? $this->request->data['Menu']['id'] : null));
        $this->set('metaData', $this->_adminFormMetaFields());
        $this->_adminPopulateLookups();

        $this->set('return', $this->Session->read("Admin.$modelAlias.return"));

        // Set the default template, this can be overridden in controllers using $this->view
        // or $this->render().
        $this->view = '../TranslationTranslations/admin_form';

        return;
    }

    public function admin_add_translation($language_id, $phrase_id, $id = null)
    {
        return $this->admin_add_translation($language_id, $phrase_id, $id);
    }
}