<?php
App::uses('AppController', 'Controller');


class TranslationPhrasesController extends AppController {

    public $components = array('RequestHandler');

    public function beforeFilter() {

        $this->adminActions[] = 'admin_manage';

        parent::beforeFilter();

    }

    public function _adminFormFields()
    {

        $fields = parent::_adminFormFields();

        $allModelNames = App::objects('model');

        $fields['TranslationPhrase.model_id']['type'] = 'string';
        $fields['TranslationPhrase.model']['type'] = 'select';
        $fields['TranslationPhrase.default_value']['type'] = 'text_plain';

        return $fields;

    }

    public function _adminPopulateLookups()
    {
        // List of models

        $models = App::objects('model');

        $model_list = array();

        $excluded_models = array(
            'AppModel',
        );

        foreach ($models as $model) {

            if (!in_array($model, $excluded_models)) {
                $model_list[$model] = $model;
            }

        }

        $this->set('models', $model_list);


        // List of Translation Phrase Groups
        $this->loadModel('EvTranslation.TranslationPhraseGroup');
        $groups = $this->TranslationPhraseGroup->find('list');

        $this->set('translationPhraseGroups', $groups);
    }


    public function admin_manage($group_id, $language_id)
    {

        $Model = $this->{$this->modelClass};
        $modelAlias = $Model->alias;

        $this->_processMultiEdit();
        $this->_processLimit();
        $this->_adminPopulateFilterLookups();
        $this->set('columns', $this->_adminIndexColumns());
        $this->set('toolbar', $this->_adminIndexToolbar());
        $this->set('actions', $this->_adminIndexActions());
        $this->set('multiEditActions', $this->_adminMultiEditActions());

        $this->paginate = $this->_adminIndexPaginate();
        $this->set('data', $this->paginate());

        $this->set('title_for_layout', InflectorExt::pluralize($Model->displayName));

        $this->loadModel('EvTranslation.TranslationPhraseGroup');
        $this->loadModel('EvTranslation.TranslationTranslation');

        $group = $this->TranslationPhraseGroup->find('first', array(
            'conditions' => array(
                'id' => $group_id,

            )
        ));

        $this->paginate = array(
            'contain' => array(
                'TranslationTranslation' => array(
                    'conditions' => array(
                        'TranslationTranslation.translation_language_id' => $language_id
                    )
                )
            ),
            'conditions' => array(
                'TranslationPhrase.translation_phrase_group_id' => $group_id,
                'TranslationPhrase.is_hidden' => '0'
            )
        );

        $data = $this->paginate('TranslationPhrase');

        // Loop the phrases to find the set the default values
        foreach ($data as $id => $item) {

            if(isset($item['TranslationPhrase']['model']) && $item['TranslationPhrase']['model'] != '') {

                $this->loadModel($item['TranslationPhrase']['model']);
                $model_data = $this->{$item['TranslationPhrase']['model']}->find('first', array(
                    'conditions' => array(
                        'id' => $item['TranslationPhrase']['model_id']
                    )
                ));

                if (!empty($model_data)) {
                    $data[$id]['TranslationPhrase']['original_string'] = $model_data[$item['TranslationPhrase']['model']][$item['TranslationPhrase']['model_field']];
                }
            }

        }

        $this->set('phrases', $data);
        $this->set('group', $group);
        $this->set('language_id', $language_id);

        // Set the default template, this can be overridden in controllers using $this->view
        // or $this->render().
        $this->view = '../TranslationPhrases/admin_view';

        return;
    }
}