<div class="edit-form cr">
	<div class='tab__content' data-title='Content'>

		<div class="row">
			<div class="col-xs-12 col-sm-6">
				<h1 class="title">Transaction #<?php echo $data['Transaction']['id']; ?></h1>
				<div class="panel panel-default">
					<div class="panel-heading">Transaction Overview</div>
					<div class="panel-body">
						<dl class="transactions_details">
							<dt>Details:</dt>
							<dd><?php echo $this->Transactions->generateDisplayName($data); ?></dd>

							<dt>Transaction Date:</dt>
							<dd><?php echo $this->Time->format('jS M Y, g:ia', $data['Transaction']['created']); ?></dd>

							<dt>Transaction Amount:</dt>
							<dd><?php echo $this->Number->currency($data['Transaction']['transaction_amount'], $currencies[$data['Transaction']['currency_id']]); ?></dd>
						</dl>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-sm-6">

				<h1 class="title">Transaction <span>Items</span></h1>

				<table class="results results-borderless" style="margin: 0px;padding:0px;">
					<thead>
						<tr>
							<th>Item</th>
							<th>Price</th>
						</tr>
					</thead>
					<tbody>
					<?php if (! empty($data['TransactionsItem'])): ?>
						<?php foreach ($data['TransactionsItem'] as $item): ?>
							<tr>
								<td>
									<?php echo $item['description']; ?>
								</td>
								<td>
									<?php echo $this->Number->currency($item['amount'], $currencies[$data['Transaction']['currency_id']]); ?>
								</td>
							</tr>
						<?php endforeach; ?>
					<?php endif; ?>
					</tbody>
				</table>
			</div>
		</div>

		<?php echo $this->Element('EvTransactions.refund_form', array('refund' => $data)); ?>
	</div>
</div>
<?php echo $this->Html->css('EvTransactions.transaction_view'); ?>
