<?php
App::uses('AppHelper', 'View/Helper');

class TransactionsHelper extends AppHelper {

	/**
	 * generate the transactions display name
	 * will try and load the related models name as defined in config
	 * or will fall back on imploding all the transaction item descriptions
	 *
	 * @param array transaction row array with related data and transaction items
	 * @return string the disply name for this transaction
	 */
	public function generateDisplayName($row) {
		// try to get the display name if set
		$displayName = Configure::read('EvTransactions.listing.displayField');

		if (! empty($displayName) || ! isset($displayName[$row['Transaction']['model']])) {
			$rowName = $displayName[$row['Transaction']['model']];

			$modelName = $row['Transaction']['model'];
			if (isset($row[$modelName][$rowName]) && ! empty($row[$modelName][$rowName])) {
				$display = $row[$modelName][$rowName];
			}
		}

		// not set try and just use the descriptions from the items
		if (! isset($display)) {
			$display = Hash::extract($row, 'TransactionsItem.{n}.description');
			$display = implode('<br>', $display);
		}

		// still not set, something's wrong, just set unknown
		if (! isset($display)) {
			$display = 'Unknown';
		}

		return $display;
	}

/**
 * Create an external link that directs the user to the recorded transaction in the gateway the
 * transaction was paid with.
 * @param  array $transaction The transaction to create the link from. Is passed to the gateway plugin
 *                            so appropriate data can be extracted.
 * @return string             The url to the gateway to see the transaction.
 */
	public function buildGatewayTransactionUrl($transaction) {
		$gateway = $transaction['payment_method'];

		if (empty($gateway)) {
			return null;
		}

		try {
			$gatewayHelper = $this->_View->Helpers->load($gateway);
		} catch(Exception $e) {
			return null;
		}

		$url = $gatewayHelper->buildGatewayTransactionUrl($transaction);

		return $url;
	}
}
