<?php if (isset($transactions) && ! empty($transactions)): ?>

	<table width="100%" cellspacing="0" cellpadding="0" border="0" class="transactions">
		<thead>
			<tr>
				<th>Date</th>
				<th>Item</th>
				<th>Amount</th>
				<th>Status</th>
				<th>Receipt</th>
				<?php if (isset($is_admin) && $is_admin === true): ?>
					<th>Details</th>
				<?php endif; ?>
			</tr>
		</thead>
		<tbody>
			<?php
				foreach ($transactions as $transaction):

					$row = array(
						$this->Time->format('jS M Y, g:ia', $transaction['Transaction']['created'])
					);

					$row[] = $this->Transactions->generateDisplayName($transaction);

					$row[] = $this->Number->currency($transaction['Transaction']['transaction_amount'], $transaction['Transaction']['currency_id']);
					$row[] = Inflector::humanize($transaction['Transaction']['status']);

					if ($transaction['Transaction']['status'] == 'success') {

						$row[] = $this->Html->link(
							'Receipt',
							array(
								'admin' => false,
								'plugin' => 'transactions',
								'controller' => 'transactions',
								'action' => 'view',
								$transaction['Transaction']['id']
							),
							array(
								'target' => '_blank'
							)
						);
					} else {

						$row[] = '-';
					}

					if (isset($is_admin) && $is_admin === true):

						$row[] = $this->Html->link(
							'Details',
							array(
								'admin' => true,
								'plugin' => 'transactions',
								'controller' => 'transactions',
								'action' => 'view',
								$transaction['Transaction']['id']
							)
						);

					endif;

					echo $this->Html->tableCells(
						$row,
						array(
							'class' => 'odd',
						),
						array(
							'class' => 'even'
						)
					);
				endforeach;
			?>
		</tbody>
	</table>

	<?php if (! isset($is_admin) || $is_admin !== true): ?>
		<?php echo $this->Element('EvTransactions.paginate'); ?>
	<?php endif; ?>

<?php else: ?>

	<p class="no-transactions">You have made no transactions.</p>

<?php endif; ?>

<?php echo $this->Html->css('EvTransactions.transaction_view'); ?>
