<?php

App::uses('EvTransactionsAppModel', 'EvTransactions.Model');

class TransactionsItem extends EvTransactionsAppModel {

	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'description';

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'description' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'An item description must be entered'
			),
		),
	);

	/**
	 * belongsTo associations
	 *
	 * @var array
	 */
	public $belongsTo = array(
		'Transaction' => array(
			'className' => 'EvTransactions.Transaction'
		)
	);

	/**
	 * redefiune the model constructor so we can setup the dynamic relationship
	 */
	public function __construct($id = false, $table = null, $ds = null) {
		parent::__construct($id, $table, $ds);

		// setup dynamic relation
		$relation = Configure::read('EvTransactions.transactionsItemRelation');
		if (! empty($relationships)) {
			$belongsTo = array();
			foreach ($relationships as $key => $value) {
				$belongsTo[$key] = $value;
			}

			if (! empty($belongsTo)) {
				$this->bindModel(
					array(
						'belongsTo' => $belongsTo
					),
					false
				);
			}
		}
	}

}
