<?php

App::uses('EvTransactionsAppController', 'EvTransactions.Controller');

class TransactionsController extends EvTransactionsAppController {

	public $helpers = array('EvTransactions.Transactions');

	public function beforeFilter() {
		$this->adminActions[] = 'admin_refund';
		$this->adminActions[] = 'admin_users_transactions';

		parent::beforeFilter();
	}

	/**
	 * admin view for showing transaction details and the refund form
	 */
	public function admin_view($id) {
		$data = $this->Transaction->readForView(
			$id,
			array(
				'contain' => array(
					'TransactionsItem'
				)
			)
		);

		$this->set('data', $data);
	}

	/**
	 * process any refund forms from the amend.
	 * Currently only marks it as refunded in our system.
	 */
	public function admin_refund() {
		$Model = $this->{$this->modelClass};

		if (isset($this->request->data[$Model->alias]['id']) && ! empty($this->request->data[$Model->alias]['id'])) {

			if ($Model->save($this->request->data)) {

				$this->Session->setFlash(array(
					'title' => 'Refund Set',
					'description' => 'The refund details have been successfully applied to the transaction record'
				), 'flash_success');
			} else {

				$this->Session->setFlash(array(
					'title' => 'Refund failed',
					'description' => 'There was an issue applying the refund details to the transaction record'
				), 'flash_fail');
			}
		}

		$this->redirect(
			$this->referer()
		);
	}

	/**
	 * requestAction function for getting a users transactions and returns the html for a tab in the admin
	 *
	 * @param int user id we are pulling transactions for
	 */
	public function admin_users_transactions($userId) {
		$Model = $this->{$this->modelClass};

		$params = $Model->transactionListParams($userId);

		$transactions = $Model->find('all', $params);

		$this->set('transactions', $transactions);

		$this->render('admin_users_transactions', 'ajax');
	}

	/**
	 * list all the transactions for the logged in user.
	 * Linked to this page from somewhere like 'my account section'
	 *
	 */
	public function my_transactions() {
		$Model = $this->{$this->modelClass};

		$user = $this->Auth->user();

		$this->paginate = $Model->transactionListParams($user['User']['id'], 10);

		$transactions = $this->paginate();

		$this->set('transactions', $transactions);

		$pageId = Configure::read('EvTransactions.listing.pageId');
		if (! empty($pageId)) {
			$this->assignPage($pageId);
		}
	}

	/**
	 * view the details for individual transaction
	 * shows as a "receipt" rather then within the page layout
	 */
	public function view($id) {
		$this->_receiptView($id);
		$this->view = 'EvTransactions.receipt';
		$this->layout = 'EvTransactions.receipt';
	}

	/**
	 * generate a receipt view for the selected transaction
	 *
	 * @param int transaction id we are loading
	 */
	protected function _receiptView($transactionId) {
		$Model = $this->{$this->modelClass};

		$transaction = $Model->readForView(
			$transactionId,
			array(
				'contain' => array(
					'TransactionsItem'
				)
			)
		);
		$items = array();
		$taxRate = Configure::read('EvTransactions.taxRate');

		if (isset($transaction['TransactionsItem']) && ! empty($transaction['TransactionsItem'])) {
			foreach ($transaction['TransactionsItem'] as $item) {
				$amountNotax = $item['amount'];
				$tax = 0;

				if ($taxRate > 0) {
					$amountNotax = ($item['amount'] / $taxRate);
					$tax = $item['amount'] - $amountNotax;
				}

				$items[] = array(
					'description' => $item['description'],
					'subtotal' => $amountNotax,
					'tax' => $tax,
					'total' => $item['amount']
				);
			}
		}

		$this->set(array(
			'items' => $items,
			'grandtotal' => $transaction['Transaction']['transaction_amount'],
			'receipt_date' => $transaction['Transaction']['created'],
			'currencyId' => $transaction['Transaction']['currency_id']
		));

		$this->set('title_for_layout', Configure::read('SiteSetting.general.site_title') . ' - Transaction Details');
	}

}
