<?php

App::uses('Component', 'Controller');
App::import('Lib', 'Transactions.GatewayInterface');

include('../../Vendor/autoload.php');

use Omnipay\Omnipay as Omnipay;
use Omnipay\Common\CreditCard as OmnipayCreditCard;

/*
 Worldpay gateway settings are;

 array(
	'installationId' => '',			// the id that exists per merchant account for worldpay
	'accountId' => '',				// i dont THINK this is used, as the installationId above is used instead
	'secretWord' => '',
	'callbackPassword' => '',
	'testMode' => false				// this wants to be true if we're in testing mode
);

 */
class WorldpayComponent extends Component implements GatewayInterface {

	/**
	 * the controller that this transaction component is associated with
	 * @var EvCoreController
	 */
	private $__controller = null;

	/**
	 * the gateway itself, in this case, an Omnipay Worldpay instance
	 * @var \Omnipay\WorldPay\Gateway
	 */
	protected $_api = null;

	/**
	 * array of parameters that is set and then sent to gateway purchase method
	 * @var array
	 */
	protected $_params = [];

	/**
	 * the credit card being passed to the payment method
	 * @var \Omnipay\Common\CreditCard
	 */
	protected $_card = null;

	/**
	 * Initialise the gateway with a controller and any other stuff you want to happen initially
	 */
	public function initialize(Controller $controller) {

		parent::initialize($controller);

		$this->__controller = $controller;

		$this->_api = Omnipay::create('WorldPay');
	}

	/**
	 * init
	 *
	 * Use the function setup and connection / settings that need setting up in the gateway
	 */
	public function setup() {
		if (Configure::read('db.config') == 'live') {
			$this->_config = Configure::read('Transactions.worldpay.live');
			$this->_api->setTestMode(false);
		}
		else {
			$this->_config = Configure::read('Transactions.worldpay.dev');
			$this->_api->setTestMode(true);
		}
	}

	/**
	 * setupPayment
	 *
	 * Use this function setup the actual payment, i.e. setup the basket, the amount to take etc...
	 *
	 * @param int - transaction id we have created
	 * @param array $return - array with 2 keys of 'return', 'cancel'. Containing either a link or router array for redirecting user
	 * @param array $model - array with two keys of 'model' and 'model_id', used to link transactions polymorphically to other model items
	 * @param float|array $amount - amount of monies to take (I GOT YOUR MONIESSSSSS), or array of 'amount' and 'currency' to change currencies (will take default from config)
	 * @param array $items - multidimenisional array break down of the transaction items, required elements are 'description' and 'amount'
	 * @param mixed $extra - variable allowing you to pass ay data needed to the gateway, could be things like addresses that are not tracked by the transactions model
	 */
	public function setupPayment($transactionId, $return, $model, $amount, $items, $extra = array()) {
		$this->_params = [];

		$this->Transaction = ClassRegistry::init('Transactions.Transaction');
		$this->Transaction->id = $transactionId;

		$this->_card = new OmnipayCreditCard();

		$this->_card->setFirstName($extra['user']['first_name']);
		$this->_card->setLastName($extra['user']['last_name']);
		$this->_card->setEmail($extra['user_details']['email']);
		$this->_card->setCountry('GB');
		$this->_card->setAddress1($extra['billing_address']['address1']);
		$this->_card->setAddress2($extra['billing_address']['address2']);
		$this->_card->setCity($extra['billing_address']['city']);
		$this->_card->setPostcode($extra['billing_address']['postcode']);

		if (is_array($amount)) {
			$total = $amount['amount'];
			$currency = $amount['currency'];
		} else {
			$total = $amount;
			$currency = CakeSession::read('EvCurrency.currencyCode');
		}

		$this->_params = array(
			'transactionId' => $transactionId . "-" . time(),
			'transactionReference' => 'test',
			'returnUrl' => $return['return'],
			'currency' => $currency,
			'amount' => $total,
			'description' => 'Payment to ' . Configure::read('SiteSetting.site_title'),
			'clientIp' => $this->__controller->request->clientIp()
		);

		$this->_params = array_merge($this->_params, $this->_config);

		// $this->__controller->Session->write('Transactions.SagepayDirect.params', $params);
		$this->__controller->Session->write('Transactions.Worldpay.params', $this->_params);

		// this should be the new card variable, declared above the array
		$this->_params['card'] = $this->_card;
	}

	/**
	 * getPayment
	 *
	 * Everything should be setup, actually take the payment
	 *
	 * @param int transactions id
	 * @return mixed dependent on the gateway, value is return straight from the transaction component to user anyway
	 */
	public function getPayment($transaction_id) {
		try {
			$response = $this->_api->purchase($this->_params)->send();
			if ($response->isSuccessful()) {
				// mark order as complete
				// probably something like taking the transaction id from the response, and saving it
				// to our own transaction object?
			} elseif ($response->isRedirect()) {
				$response->redirect();
			} else {
				// display error to customer
				exit($response->getMessage());
			}
		} catch (\Exception $e) {
			// internal error, log exception and display a generic message to the customer
			exit('Sorry, there was an error processing your payment. Please try again later.');
		}
	}

	/**
	 * return
	 *
	 * deal with a return from the gateway and check for success / fail
	 *
	 * @return array - with three elements,
	 *				 - 'result' = true/false value
	 *  			 - 'message' = text message about transaction (i.e. reason for failing)
	 * 				 - 'transaction_id' = int of the transaction row
	 */
	public function processReturn() {

	}

}
