<?php

App::uses('AppComponent', 'Controller/Component');

class GatewayBaseComponent extends AppComponent {

	/**
	 * hold the loaded config
	 */
	protected $_config = null;

	/**
	 * process the amount value of setupPayment
	 *
	 * @param 	array|float 	$amount 	Either array of amount / currency code or just the amount
	 * @return 	array
	 */
	public function processAmount($amount) {
		if (! is_array($amount)) {
			$amount = array(
				'amount' => $amount,
				'currency' => CakeSession::read('EvCurency.currencyId')
			);
		}

		return $amount;
	}

	/**
	 * update the transaction record and mark it as failed withj the given message
	 *
	 * @param 	int 	$transactionId 	 	The transaction ID number
	 * @param 	string 	$message 			The failed message
	 * @return mixed On success Model::$data if its not empty or true, false on failure
	 */
	public function failTransaction($transactionId, $message) {
		$Transaction = EvClassRegistry::init('EvTransactions.Transaction');

		$Transaction->id = $transactionId;
		return $Transaction->save(
			array(
				'status' => 'failed',
				'message' => $message
			)
		);
	}

	/**
	 * update the transaction record and set payment token
	 *
	 * @param 	int 	$transactionId 	 	The transaction ID number
	 * @param 	string 	$token 				The token to set
	 * @return bool|array See Model::save() False on failure or an array of model data on success.
	 */
	public function setPaymentToken($transactionId, $token) {
		$Transaction = EvClassRegistry::init('EvTransactions.Transaction');

		$Transaction->id = $transactionId;
		return $Transaction->saveField('payment_token', $token);
	}
}
