<?php echo $this->Html->css('Transactions.refund_form'); ?>
<h2>Refund</h2>

<?php if (isset($refund['Transaction']['refund_amount']) && $refund['Transaction']['refund_amount'] > 0): ?>
	<dl class="transactions_details">

		<dt>Refund Info:</dt>
		<dd><?php echo $refund['Transaction']['refund_message']; ?></dd>

		<dt>Refund Amount:</dt>
		<dd>&pound;<?php echo number_format($refund['Transaction']['refund_amount'], 2); ?></dd>

	</dl>
<?php endif; ?>

<?php
	if (! isset($refund['Transaction']['status']) || $refund['Transaction']['status'] != 'full refund'):

		echo $this->Form->create('Transactions.Transaction', array(
			'url' => array(
				'admin' => true,
				'plugin' => 'transactions',
				'controller' => 'transactions',
				'action' => 'refund'
			),
			'class' => 'transaction-refund'
		));

		echo $this->Form->input('Transaction.id', array(
			'type' => 'hidden',
			'value' => $refund['Transaction']['id']
		));


		echo $this->Form->input('Transaction.status', array(
			'type' => 'select',
			'options' => array(
				'full refund' => 'Full Refund',
				'partial refund' => 'Partial Refund'
			)
		));

		echo $this->Form->input('Transaction.refund_message', array(
			'type' => 'string',
			'class' => 'longer'
		));

		echo $this->Form->input('Transaction.refund_amount', array(
			'type' => 'string',
			'label' => 'Refund Amount &pound;'
		));

		echo '<div class="submit edit-form__submit">';
			echo $this->Form->submit('btn--save.png', array('div'=>false));
		echo '</div>';

		echo $this->Form->end();

	endif;
?>