<?php

class PaytrailController extends TransactionsAppController {

	public $components = array(
		'Transactions.Paytrail'
	);

	public function beforeFilter() {
		$this->Auth->allow(
			array(
				'response',
				'template',
				'notify'
			)
		);
		parent::beforeFilter();
	}

	public function template() {
		$this->layout = false;
		$this->view = 'template';
	}

/**
 * Notify callback
 *
 * This is called automatically by paytrail. In most cases the user returning
 * will trigger the processReturn so this wont be doing anything, however in
 * cases where the user didnt return (or other edge cases) this acts as a
 * guaranteed return from the gateway to make sure we're getting the actual
 * payment status back.
 *
 * A user will never be calling this method directly.
 *
 * @return void
 */
	public function notify() {
		$params = $this->params;
		$this->Paytrail->processReturn();

		die('ok');
	}

/**
 * Pending callback
 *
 * We have to provide a path for paytrail but this is not in use or needed for
 * standard operation.
 *
 * @return void
 */
	public function pending() {
		die('handle pending');
	}
}
