<?php

App::uses('Component', 'Controller');
App::import('Lib', 'Transactions.GatewayInterface');

use Omnipay\Omnipay as Omnipay;
use Symfony\Component\HttpFoundation\Request;

class RedsysComponent extends Component implements GatewayInterface {

	private $__controller = null;

	protected $_config = null;

	protected $_api = null;

	protected $_data = null;

/**
 * Define an array of language code mappings.
 *
 * @var array
 */
	protected $_languages = array(
		'spa' => '001',
		'eng' => '002',
		'cat' => '003',
		'fre' => '004',
		'deu' => '005',
		'dut' => '006',
		'ita' => '007',
		'swe' => '008',
		'por' => '009',
		'pol' => '011',
		'glg' => '012',
		'baq' => '013'
	);

	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->__controller = $controller;
		$this->_api = Omnipay::create('Sermepa');
	}

/**
 * init
 *
 * Use the function setup and connection / settings that need setting up in the gateway
 */
	public function setup() {
		if (Configure::read('db.config') === 'live') {
			$this->_config = Configure::read('Transactions.redsys.live');
		} else {
			$this->_config = Configure::read('Transactions.redsys.dev');
			$this->_api->setTestMode(true);
		}

		$this->_api->setMerchantCode($this->_config['fuc_code']);
		$this->_api->setMerchantName($this->_config['brandname']);
		$this->_api->setTerminal($this->_config['terminal']);
		$this->_api->setMerchantKey($this->_config['merchant_key']);
		$this->_api->setSignatureMode($this->_config['signature_mode']);
	}

/**
 * setupPayment
 *
 * Use this function setup the actual payment, i.e. setup the basket, the amount to take etc...
 *
 * @param int - transaction id we have created
 * @param array $return - array with 2 keys of 'return', 'cancel'. Containing either a link or router array for redirecting user
 * @param array $model - array with two keys of 'model' and 'model_id', used to link transactions polymorphically to other model items
 * @param float|array $amount - amount of monies to take (I GOT YOUR MONIESSSSSS), or array of 'amount' and 'currency' to change currencies (will take default from config)
 * @param array $items - multidimenisional array break down of the transaction items, required elements are 'description' and 'amount'
 * @param mixed $extra - variable allowing you to pass ay data needed to the gateway, could be things like addresses that are not tracked by the transactions model
 */
	public function setupPayment($transactionId, $return, $model, $amount, $items, $extra = array()) {
		$this->Transaction = ClassRegistry::init('Transactions.Transaction');
		$this->Transaction->id = $transactionId;

		$description = 'Payment to ' . $this->_config['brandname'];
		// Override generic description with custom one if exists
		if (isset($extra['description'])) {
			$description = $extra['description'];
		}

		// Set the language code.
		$defaultLanguage = !empty($this->_config['language']) ? $this->_config['language'] : 'eng';
		$language = !empty($extra['language']) ? $extra['language'] : $defaultLanguage;
		$language = !empty($this->_languages[$language]) ? $this->_languages[$language] : $this->_languages[$defaultLanguage];

		// Set currency
		if (is_array($amount)) {
			$amount = $amount['amount'];
			$currency = $amount['currency'];
		} else {
			$currency = Configure::read('Transactions.currency');
		}

		$this->_data = array(
			'amount' => $amount * 100,
			'description' => $description,
			'returnUrl' => $return['return'],
			'merchantURL' => $return['return'],
			'cancelUrl' => $return['cancel'],
			'currency' => $currency,
			'consumerLanguage' => $language,
			'transaction_id' => $transactionId,
			'token' => str_pad($transactionId, 4, 0, STR_PAD_LEFT)
		);

		$this->__controller->Session->write('Transactions.redsys.data', $this->_data);
	}

/**
 * getPayment
 *
 * Everything should be setup, actually take the payment
 *
 * @param int transactions id
 * @return mixed dependent on the gateway, value is return straight from the transaction component to user anyway
 */
	public function getPayment($transactionId) {
		$response = $this->_api->purchase($this->_data)->send();

		if ($response->isRedirect()) {
			// omnipay wants to redirect
			$response->redirect();
		} else {
			// no redirect, check if successfull
			if ($response->isSuccessful()) {
				$redirectUrl = $this->_data['returnUrl'];
			}
		}

		// check if redirect has been set (was successful) if not redirect to cancel
		if (!isset($redirectUrl)) {
			$redirectUrl = $this->_data['cancelUrl'];
		}

		header("Location:" . $redirectUrl);

		// Ensure no further code gets excuted as we are redirecting
		exit;
	}

/**
 * return
 *
 * deal with a return from the gateway and check for success / fail
 *
 * @return array - with three elements,
 *               - 'result' = true/false value
 *               - 'message' = text message about transaction (i.e. reason for failing)
 *               - 'transaction_id' = int of the transaction row
 */
	public function processReturn() {
		// Read the session data
		$this->_data = $this->__controller->Session->read('Transactions.redsys.data');

		// Remove the session data (good practice)
		$this->__controller->Session->delete('Transactions.redsys.data');

		// Send to complete the purchase
		$response = $this->_api->checkCallbackResponse(new Request([], $this->__controller->request->query));

		// Save the Redsys response
		$data = array(
			'transaction_id' => $this->_data['transaction_id'],
			'order' => $this->__controller->request->query['Ds_Order'],
			'signature' => $this->__controller->request->query['Ds_Signature'],
			'response' => $this->__controller->request->query['Ds_Response'],
			'authorisation_code' => $this->__controller->request->query['Ds_AuthorisationCode']
		);
		ClassRegistry::init('Transactions.Redsys')->save($data);

		// check response
		if ($response === true) {
			return array(
				'result' => true,
				'message' => 'Payment successful',
				'transaction_id' => $this->_data['transaction_id']
			);
		} else {
			return array(
				'result' => false,
				'message' => 'Payment was unsuccessful',
				'transaction_id' => $this->_data['transaction_id']
			);
		}
	}

}
