<?php
use Ogone\Passphrase;
use Ogone\Ecommerce\EcommercePaymentRequest;
use Ogone\ShaComposer\AllParametersShaComposer;
use Ogone\ParameterFilter\ShaInParameterFilter;
use Ogone\ParameterFilter\ShaOutParameterFilter;
use Ogone\FormGenerator\SimpleFormGenerator;
use Ogone\Ecommerce\EcommercePaymentResponse;

App::uses('Component', 'Controller');
App::import('Lib', 'Transactions.GatewayInterface');


class OgoneComponent extends Component implements GatewayInterface {

	private $__controller = null;

	protected $_config = null;

	protected $_data = null;

	protected $_shaComposer = null;

/**
 * Define an array of language code mappings.
 *
 * @var array
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->__controller = $controller;
	}

/**
 * init
 *
 * Use the function setup and connection / settings that need setting up in the gateway
 */
	public function setup() {
		$prodGateway = Configure::read('Transactions.ogone.live');
		$stagingGateway = Configure::read('Transactions.ogone.dev');

		if (CakePlugin::loaded('BuzzSites')) {
			$Site = ClassRegistry::init('BuzzSites.Site');
			$site = $Site->getActiveSite();

			if (
				isset($site['Site']['production_gateway_credentials']) &&
				isset($site['Site']['staging_gateway_credentials'])
			) {
				$prodGateway = json_decode($site['Site']['production_gateway_credentials'], true);
				$stagingGateway = json_decode($site['Site']['staging_gateway_credentials'], true);

				$tplUrl = Router::url(array(
					'plugin' => 'transactions',
					'controller' => 'ogone',
					'action' => 'template'
				), true);

				if (! empty($tplUrl)) {
					$prodGateway['template'] = $tplUrl;
					$stagingGateway['template'] = $tplUrl;
				}
			}
		}

		if (Configure::read('db.config') === 'live' || Configure::read('transactions.forceLive')) {
			$this->_config = $prodGateway;
			$this->_ogoneUri = EcommercePaymentRequest::PRODUCTION;
		} else {
			$this->_config = $stagingGateway;
			$this->_ogoneUri = EcommercePaymentRequest::TEST;
		}

		$passphrase = new Passphrase($this->_config['SHASIGN']);

		$this->_shaComposer = new AllParametersShaComposer($passphrase);
		$this->_shaComposer->addParameterFilter(new ShaInParameterFilter);
	}

/**
 * setupPayment
 *
 * Use this function setup the actual payment, i.e. setup the basket, the amount to take etc...
 *
 * @param int - transaction id we have created
 * @param array $return - array with 2 keys of 'return', 'cancel'. Containing either a link or router array for redirecting user
 * @param array $model - array with two keys of 'model' and 'model_id', used to link transactions polymorphically to other model items
 * @param float|array $amount - amount of monies to take (I GOT YOUR MONIESSSSSS), or array of 'amount' and 'currency' to change currencies (will take default from config)
 * @param array $items - multidimenisional array break down of the transaction items, required elements are 'description' and 'amount'
 * @param mixed $extra - variable allowing you to pass ay data needed to the gateway, could be things like addresses that are not tracked by the transactions model
 */
	public function setupPayment($transactionId, $return, $model, $amount, $items, $extra = array()) {
		$this->Transaction = ClassRegistry::init('Transactions.Transaction');
		$this->Transaction->id = $transactionId;

		$description = 'Payment to ' . $this->_config['TITLE'];
		// Override generic description with custom one if exists
		if (isset($extra['description'])) {
			$description = $extra['description'];
		}

		// Set the language code.
		$defaultLanguage = !empty($this->_config['language']) ? $this->_config['language'] : 'eng';
		$language = !empty($extra['language']) ? $extra['language'] : $defaultLanguage;
		$language = !empty($this->_languages[$language]) ? $this->_languages[$language] : $this->_languages[$defaultLanguage];

		// Set currency
		if (is_array($amount)) {
			$amount = $amount['amount'];
			$currency = $amount['currency'];
		} else {
			$currency = Configure::read('Transactions.currency');
		}

		$this->_data = array(
			'amount' => $amount * 100,
			'description' => $description,
			'returnUrl' => $return['return'],
			'merchantURL' => $return['return'],
			'cancelUrl' => $return['cancel'],
			'currency' => $currency,
			'consumerLanguage' => $language,
			'transaction_id' => $transactionId,
			'token' => str_pad($transactionId, 4, 0, STR_PAD_LEFT),
			'extra' => $extra
		);

		$this->__controller->Session->write('Transactions.ogone.data', $this->_data);
	}

/**
 * getPayment
 *
 * Everything should be setup, actually take the payment
 *
 * @param int transactions id
 * @return mixed dependent on the gateway, value is return straight from the transaction component to user anyway
 */
	public function getPayment($transactionId) {
		$ecommercePaymentRequest = new EcommercePaymentRequest($this->_shaComposer);
		$ecommercePaymentRequest->setOrderid($transactionId);
		$ecommercePaymentRequest->setAmount((int)$this->_data['amount']);
		$ecommercePaymentRequest->setPspid($this->_config['PSPID']);
		$ecommercePaymentRequest->setCurrency($this->_data['currency']);
		$ecommercePaymentRequest->setLanguage($this->_config['LANGUAGE']);
		$ecommercePaymentRequest->setAccepturl($this->_data['returnUrl']);
		$ecommercePaymentRequest->setTP($this->_config['template']);
		$ecommercePaymentRequest->setOgoneUri($this->_ogoneUri);
		$ecommercePaymentRequest->validate();

		$formGenerator = new SimpleFormGenerator;
		$html = $formGenerator->render($ecommercePaymentRequest);

		$this->__controller->set('content', $html);

		// Ogone requires a local form posts them the data, similar to how paypal's buy now button works
		// To get round an additional step/page, a simple view is included that forces the form to post
		// whilst showing a loading indicator.
		$view = new View();
		$view->layout = false;
		$view->plugin = 'Transactions';
		$view->set('content', $html);
		$view->viewPath = 'Ogone';

		echo $view->render('payment_form');

		exit;
	}

/**
 * return
 *
 * deal with a return from the gateway and check for success / fail
 *
 * @return array - with three elements,
 *               - 'result' = true/false value
 *               - 'message' = text message about transaction (i.e. reason for failing)
 *               - 'transaction_id' = int of the transaction row
 */
	public function processReturn() {
		$data = $_REQUEST;
		$passphrase = new Passphrase($this->_config['SHARETURN']);

		$this->_shaComposer = new AllParametersShaComposer($passphrase);
		$this->_shaComposer->addParameterFilter(new ShaOutParameterFilter);

		$ecommercePaymentResponse = new EcommercePaymentResponse($data);

		$this->Transaction = ClassRegistry::init('Transactions.Transaction');
		$this->Transaction->id = $data['orderID'];

		if ($ecommercePaymentResponse->isValid($this->_shaComposer) && $ecommercePaymentResponse->isSuccessful()) {

			$this->Transaction->save(array(
				'Transaction' => array(
					'message' => 'Payment successful',
					'payment_token' => $data['PAYID'],
					'status' => 'success'
				)
			));

			return array(
				'result' => true,
				'message' => 'Payment successful',
				'transaction_id' => $data['orderID']
			);
		} else {
			// perform logic when the validation fails

			$this->Transaction->save(array(
				'Transaction' => array(
					'status' => 'failed',
					'message' => $e->getMessage()
				)
			));

			return array(
				'result' => false,
				'message' => 'Payment was unsuccessful',
				'transaction_id' => $data['orderID']
			);
		}
	}

}
