<?php // @todo: will need to check here again for the right data to disable once the structure for renewals is confirmed?>
<div class='edit-form'>

	<div class='edit-form__header'>
		<h1 class="transactions-header title">
			Transaction #<?php echo $data['Transaction']['id']; ?>
			<?php
				echo $this->Html->link('Back to User Details', array(
					'admin' => true,
					'controller' => 'users',
					'action' => 'edit',
					$data['Transaction']['user_id']
				), array(
					'class' => 'back-link'
				));
			?>
		</h1>

		<?php echo $this->Element('toolbar'); ?>
	</div>

	<div class='tab__content' data-title='Content'>
		<dl class="transactions_details">

			<dt>Details:</dt>
			<dd><?php echo $this->Transactions->generateDisplayName($data); ?></dd>

			<dt>Transaction Date:</dt>
			<dd><?php echo $this->Time->format('jS M Y, g:ia', $data['Transaction']['created']); ?></dd>

			<dt>Transaction Amount:</dt>
			<dd>&pound;<?php echo $data['Transaction']['transaction_amount']; ?></dd>

		</dl>

		<h2>Transaction Items</h2>

		<dl class="transactions_details items">

			<?php if (! empty($data['TransactionsItem'])): ?>
				<?php foreach ($data['TransactionsItem'] as $item): ?>

					<dt>&pound;<?php echo number_format($item['amount'], 2); ?></dt>
					<dd><?php echo $item['description']; ?></dd>

				<?php endforeach; ?>
			<?php endif; ?>

		</dl>

		<?php echo $this->Element('Transactions.refund_form', array('refund' => $data)); ?>
	</div>

</div>
<?php echo $this->Html->css('Transactions.transaction_view'); ?>