<?php
App::uses('AppHelper', 'View/Helper');

class TransactionsHelper extends AppHelper
{
	/**
	 * generate the transactions display name
	 * will try and load the related models name as defined in config
	 * or will fall back on imploding all the transaction item descriptions
	 *
	 * @param array transaction row array with related data and transaction items
	 * @return string the disply name for this transaction
	 */
	public function generateDisplayName($row)
	{
		// try to get the display name if set
		$display_name = Configure::read('Transactions.listing.display_field');
		if (! empty($display_name) || ! isset($display_name[$row['Transaction']['model']])) {

			$row_name = $display_name[$row['Transaction']['model']];

			if (
				isset($row[$row['Transaction']['model']][$row_name]) &&
				! empty($row[$row['Transaction']['model']][$row_name])
			) {

				$display = $row[$row['Transaction']['model']][$row_name];
			}
		}

		// not set try and just use the descriptions from the items
		if (! isset($display)) {

			$display = Hash::extract($row, 'TransactionsItem.{n}.description');
			$display = implode('<br>', $display);

		}

		// still not set, something's wrong, just set unknown
		if (! isset($display)) {

			$display = 'Unknown';
		}

		return $display;
	}


}
