<?php

class SagePayServerApi {

	public
		$status = '',
		$error = '';

	private
		$_vendor = null,
		$_accountType = null,
		$_testMode = false,
		$_amount = 0,
		$_currency = 'gbp',
		$_description = '',
		$_data = array(),
		$_vendorTxCode = null,
		$_response = array();

	private
		$_version = '2.23',
		$_type = 'PAYMENT',
		$_serviceUrl = 'https://live.sagepay.com/gateway/service/';

	const
		LIVE_ENV = false,
		TEST_ENV = true;

	const
		ECOMMERCE_MERCHANT_ACC = 'E',
		CONTINUOUS_AUTHORITY_ACC = 'C',
		MAIL_ORDER_TELEPHONE_ACC = 'M';

	public function __construct() {

		$this->setAccountType(self::ECOMMERCE_MERCHANT_ACC);

	}

	public function setVendor($vendor) {
		$this->_vendor = $vendor;
	}

	public function setAccountType($accountType) {
		$this->_accountType = strtoupper($accountType);
	}

	public function setTestMode($mode) {

		if ($mode===true) {
			$this->_testMode = true;
			$this->_serviceUrl = 'https://test.sagepay.com/gateway/service/';
		} else {
			$this->_testMode = false;
			$this->_serviceUrl = 'https://live.sagepay.com/gateway/service/';
		}

	}

	public function setAmount($amount, $currency=null) {

		$this->_amount = $amount;

		if ($currency) {
			$this->_setCurrency(strtolower($currency));
		}

	}

	private function _setCurrency($currency) {
		$this->_currency = $currency;
	}

	public function setDescription($description) {
		$this->_description = $description;
	}

	public function setVendorTxCode($vendorTxCode) {
		$this->_vendorTxCode = $vendorTxCode;
	}

	public function getVendorTxCode() {
		return $this->_vendorTxCode;
	}

	public function makePayment($data) {

		$this->_setData($data);

		$this->_data['Profile'] = 'NORMAL';

		$data = $this->_formatData();

		$this->_requestPost($this->_serviceUrl . 'vspserver-register.vsp', $data);

		return $this->_response;

	}

	public function makeRepeatPayment($data) {

		$this->_type = 'REPEAT';

		$this->_setData($data);

		$data = $this->_formatData();

		$this->_requestPost($this->_serviceUrl . 'repeat.vsp', $data);

		return $this->_response;

	}

	public function makeRefundPayment($data) {

		$this->_type = 'REFUND';

		$this->_setData($data);

		$data = $this->_formatData();

		$this->_requestPost($this->_serviceUrl . 'refund.vsp', $data);

		return $this->_response;

	}

	private function _setData($data) {

		$this->_data = $data;

		// Use test data for testing mode
		if ($this->_testMode && $this->_type=='PAYMENT') {

			$this->_data['BillingAddress1'] = '88';
			$this->_data['BillingAddress2'] = '88';
			$this->_data['BillingCity'] = '88';
			$this->_data['BillingPostCode'] = '412';

		}

		// Add Payment Type
		$this->_data['TxType'] = $this->_type;
		// Add the amount
		$this->_data['Amount'] = $this->_amount;
		// Add currency details
		$this->_data['Currency'] = $this->_currency;

		// Add vendor and transaction details
		$this->_data['VendorTxCode'] = $this->_vendorTxCode;
		$this->_data['VPSProtocol'] = $this->_version;
		$this->_data['Description'] = $this->_description;
		$this->_data['Vendor'] = $this->_vendor;
		$this->_data['AccountType'] = $this->_accountType;

	}

	private function _formatData() {

		$arr = array();

		// loop through $this->data
		foreach($this->_data as $key => $value){
			// assign as an item of $arr (field=value)
			$arr[] = $key . '='. urlencode($value);
		}

		// Implode the array using & as the glue and store the data
		return implode('&', $arr);

	}


	private function _requestPost($url, $data) {

		set_time_limit(60);

		$cs = curl_init();

		// Set the URL
		curl_setopt($cs, CURLOPT_URL, $url);
		// No headers, please
		curl_setopt ($cs, CURLOPT_HEADER, 0);
		// It's a POST request
		curl_setopt ($cs, CURLOPT_POST, 1);
		// Set the fields for the POST
		curl_setopt ($cs, CURLOPT_POSTFIELDS, $data);
		// Return it direct, don't print it out
		curl_setopt($cs, CURLOPT_RETURNTRANSFER,1);
		// This connection will timeout in 30 seconds
		curl_setopt($cs, CURLOPT_TIMEOUT,30);
		curl_setopt($cs, CURLOPT_SSL_VERIFYPEER, FALSE);

		$response = preg_split('/$\R?^/m',curl_exec($cs));

		// Check that we actually reached the payment server
		if (curl_error($cs)) {
			$this->status = 'FAIL';
			$this->error = curl_error($cs);
		}

		curl_close($cs);

		// Turn the reponse into an associative array
		for ($i=0; $i < count($response); $i++){
			// Find position of first "=" character
			$splitAt = strpos($response[$i], "=");
			// Create an associative array
			$this->_response[trim(substr($response[$i], 0, $splitAt))] = trim(substr($response[$i], ($splitAt+1)));
		}

	}

	public function makeVendorTxCode($id) {

		return $id . '-' . time() . rand(0, 9999);

	}

}