<?php

class TransactionsController extends TransactionsAppController
{
	public $helpers = array('Transactions.Transactions');

	public function beforeFilter() {

		$this->adminActions[] = 'admin_refund';
		$this->adminActions[] = 'admin_users_transactions';

		parent::beforeFilter();
	}

	/**
	 * admin view for showing transaction details and the refund form
	 */
	public function admin_view($id)
	{
		$data = $this->Transaction->readForView(
			$id,
			array(
				'contain' => array(
					'TransactionsItem'
				)
			)
		);

		$this->set('data', $data);
	}

	/**
	 * process any refund forms from the amend.
	 * Currently only marks it as refunded in our system.
	 */
	public function admin_refund()
	{
		if (isset($this->request->data['Transaction']['id']) && ! empty($this->request->data['Transaction']['id'])) {

			if ($this->Transaction->save($this->request->data)) {

				$this->Session->setFlash(array(
					'title' => 'Refund Set',
					'description' => 'The refund details have been successfully applied to the transaction record'
				), 'flash_success');
			} else {

				$this->Session->setFlash(array(
					'title' => 'Refund failed',
					'description' => 'There was an issue applying the refund details to the transaction record'
				), 'flash_fail');
			}
		}

		$this->redirect(
			$this->referer()
		);
	}

	/**
	 * requestAction function for getting a users transactions and returns the html for a tab in the admin
	 *
	 * @param int user id we are pulling transactions for
	 */
	public function admin_users_transactions($user_id)
	{
 		$params = $this->Transaction->transactionListParams($user_id);

		$transactions = $this->Transaction->find('all', $params);

		$this->set('transactions', $transactions);

		$this->render('admin_users_transactions', 'ajax');
	}


	/**
	 * list all the transactions for the logged in user.
	 * Linked to this page from somewhere like 'my account section'
	 *
	 */
	public function my_transactions()
	{
		$user = $this->Auth->user();

		$this->paginate = $this->Transaction->transactionListParams($user['User']['id'], 10);

		$transactions = $this->paginate();

		$this->set('transactions', $transactions);

		$page_id = Configure::read('Transactions.listing.page_id');
		if (! empty($page_id)) {

			$this->loadModel('Page');
			$page = $this->Page->readForView($page_id);

			if (! empty($page)) {

				if (isset($this->Meta) && $this->Meta instanceof MetaComponent
					&& !empty($page['MetaData']['title'])) {

					$this->Meta->set($page, 'Page');

				} else if (!empty($page['Page']['title'])) {

			    	$this->set('title_for_layout', $page['Page']['title']);

			    }

				$this->set('page', $page);
			}
		}
	}

	/**
	 * view the details for individual transaction
	 * shows as a "receipt" rather then within the page layout
	 */
	public function view($id)
	{
		$this->_receiptView($id);
		$this->render('receipt', 'receipt');
	}


	/**
	 * generate a receipt view for the selected transaction
	 *
	 * @param int transaction id we are loading
	 */
	protected function _receiptView($transaction_id)
	{
		$this->loadModel('Transactions.Transaction');
		$transaction = $this->Transaction->readForView(
			$transaction_id,
			array(
				'contain' => array(
					'TransactionsItem'
				)
			)
		);
		$items = array();
		$tax_rate = Configure::read('Transactions.tax_rate');

		if (isset($transaction['TransactionsItem']) && ! empty($transaction['TransactionsItem'])) {

			foreach ($transaction['TransactionsItem'] as $item) {

				$amount_notax = $item['amount'];
				$tax = 0;

				if ($tax_rate > 0) {

					$amount_notax = ($item['amount'] / $tax_rate);
					$tax = $item['amount'] - $amount_notax;
				}

				$items[] = array(
					'description' => $item['description'],
					'subtotal' => $amount_notax,
					'tax' => $tax,
					'total' => $item['amount']
				);
			}
		}

		$this->set(array(
			'items' => $items,
			'grandtotal' => $transaction['Transaction']['transaction_amount'],
			'receipt_date' => $transaction['Transaction']['created']
		));

		$this->set('title_for_layout', Configure::read('SiteSetting.site_title') . ' - Transaction Details');
	}

}
