<?php

App::uses('CustomEmail', 'Lib');
App::uses('Component', 'Controller');

class TransactionsComponent extends Component
{
	private $__controller = null;

	protected $_gateway = null;

	public $id = null;

	/**
	 * Sets a reference to the calling controller from within the component.
	 *
	 * @see Component::initialize()
	 */
	public function initialize(Controller $controller) {

		parent::initialize($controller);

		$this->__controller = $controller;

	}

	/**
	 * force the page onto SSL if it isn't already
	 */
	public function forceSSL() {

		if (! $this->__controller->request->is('ssl')) {

        	return $this->__controller->redirect('https://' . env('SERVER_NAME') . $this->here);
        }
    }

	/**
	 * take and process a payment
	 *
	 * based on the config gateway settings, take and process a payment from the gateway given the details
	 *
	 * @param array $return - array with 2 keys of 'return', 'cancel'. Containing either a link or router array for redirecting user
	 * @param array $model - array with two keys of 'model' and 'model_id', used to link transactions polymorphically to other model items
	 * @param float|array $amount - amount of monies to take (I GOT YOUR MONIESSSSSS), or array of 'amount' and 'currency' to change currencies (will take default from config)
	 * @param array $items - multidimenisional array break down of the transaction items, required elements are 'description' and 'amount', optional elements are model and model_id
	 * @param mixed $extra - variable allowing you to pass ay data needed to the gateway, could be things like addresses that are not tracked by the transactions model
	 * @param int 	$user_id - user id of the user to attach the transaction to, default will be logged in user.
	 * @param string $gateway - a gateway override, will default to main Transaction.gateway set in config
	 * @return mixed  - return from the getPayment gateway function. Depends on what and whether that gateway needs anything returning
	 */
	public function takePayment($return, $model, $amount, $items, $extra = null, $user_id = null, $gateway = null)
	{
		// check if we are using the config gateway or if it's been overridden
		if (is_null($gateway)) {

			$gateway = Configure::read('Transactions.gateway');
		}

		// load the component
		$this->_gateway = $this->__controller->Components->load('Transactions.' . Inflector::camelize($gateway));
		$this->_gateway->initialize($this->__controller);

		$this->_gateway->setup();

		// setup the transactions model
		$this->Transaction = ClassRegistry::init('Transactions.Transaction');

		if (empty($user_id)) {

			$user = $this->__controller->Auth->user();
			$user_id = null;
			if (isset($user['User']['id'])) {

				$user_id = $user['User']['id'];
			} elseif (isset($user['id'])) {

				$user_id = $user['id'];
			}
		}

		$data = array(
			'Transaction' => array(
				'user_id' => $user_id,
				'payment_method' => $gateway,
				'transaction_amount' => $amount,
				'status' => 'initiated',
				'model' => (isset($model['model']) && ! empty($model['model'])) ? $model['model'] : null,
				'model_id' => (isset($model['model_id']) && ! empty($model['model_id'])) ? $model['model_id'] : null
			),
			'TransactionsItem' => array()
		);

		foreach ($items as $item) {

			$data['TransactionsItem'][] = array(
				'description' => $item['description'],
				'amount' => $item['amount'],
				'model' => (isset($item['model'])) ? $item['model'] : null,
				'model_id' => (isset($item['model_id'])) ? $item['model_id'] : null,
			);
		}

		$this->Transaction->saveAll($data, array(
			'deep' => true
		));

		$this->id = $this->Transaction->id;
		$this->_gateway->setupPayment($this->Transaction->id, $return, $model, $amount, $items, $extra);


		return $this->_gateway->getPayment($this->Transaction->id);
	}

	/**
	 * checkPayment
	 *
	 * load the gateway we are dealing with then check the return data
	 *
	 * @param string $gateway - a gateway override, will default to main Transaction.gateway set in config
	 * @return bool - true or false as to whether it was sucessful
	 */
	public function checkPayment($gateway = null)
	{
		// check if we are using the config gateway or if it's been overridden
		if (is_null($gateway)) {

			$gateway = Configure::read('Transactions.gateway');
		}

		// load the component
		$this->_gateway = $this->__controller->Components->load('Transactions.' . Inflector::camelize($gateway));
		$this->_gateway->initialize($this->__controller);

		$this->_gateway->setup();

		// setup the transactions model
		$this->Transaction = ClassRegistry::init('Transactions.Transaction');

		// process the actual return values in the gateway
		$results = $this->_gateway->processReturn();

		// update the transaction status
		if (isset($results['transaction_id']) && ! empty($results['transaction_id'])) {

			$this->id = $this->Transaction->id = $results['transaction_id'];
			$this->Transaction->save(array(
				'Transaction' => array(
					'status' => (isset($results['result']) && $results['result'] === true) ? 'success' : 'failed',
					'message' => (isset($results['message']) && ! empty($results['message']) ? $results['message'] : '')
				)
			));
		}

		return (isset($results['result'])) ? $results['result'] : false;
	}

	/**
	 * send a receipt to the given email address
	 *
	 * @param array two main elements of 'to' / 'bcc' passed. Sub arrays of 'email' or 'email' => 'name' format.
	 * @param string subject to use on the emails
	 * @param array main elements allowed:
	 * - 'date' - display date for receipt
	 * - 'header' - allows you to pass stuff to receipt template above the table
	 * - 'footer' - allows you to pass stuff to receipt template below the table
	 * - 'overview' - receipt overview
	 * - 'grandtotal' - Grand total
	 * - 'items' - sub array containing the receipt lines
	 * - - 'description' - line item description
	 * - - 'total' - line item total
	 * - - 'tax' - line item tax
	 * - - 'subtotal' - line item total minus tax
	 * @param string template override for main email template
	 * @param string template override for main email layout
	 */
	public function sendReceipt($emails, $subject, $data, $template = 'receipt', $layout = 'receipt')
	{
		$CustomEmail = new CustomEmail();

		$CustomEmail->template('Transactions.' . $template, 'Transactions.' . $layout);
		$CustomEmail->theme('Site');
		$CustomEmail->from(array(Configure::read('SiteSetting.admin_email') => Configure::read('SiteSetting.site_title')));
		$CustomEmail->subject($subject);
		$CustomEmail->viewVars(array(
			'data' => $data
		));
		$CustomEmail->helpers(array(
			'Html'
		));

		if (isset($emails['to']) && ! empty($emails['to'])) {

			foreach ($emails['to'] as $email => $name) {

				if (is_numeric($email)) {

					$email = $name;
					$name = null;
				}

				$CustomEmail->addTo($email, $name);
			}
		}

		if (isset($emails['bcc']) && ! empty($emails['bcc'])) {

			foreach ($emails['bcc'] as $email => $name) {

				if (is_numeric($email)) {

					$email = $name;
					$name = null;
				}

				$CustomEmail->addBcc($email, $name);
			}
		}

		$CustomEmail->send();
	}

}
