<?php
App::uses('Component', 'Controller');
App::import('Lib', 'Transactions.GatewayInterface');
App::import('Lib', 'Transactions.PaytrailApi');

class PaytrailComponent extends Component implements GatewayInterface {

	private $__controller = null;

	protected $_config = null;

	protected $_data = null;

	protected $_shaComposer = null;

	protected $_languages = array(
		'eng' => 'en_US',
		'swe' => 'sv_SE',
		'fin' => 'fi_FI'
	);

/**
 * Define an array of language code mappings.
 *
 * @var array
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);
		$this->__controller = $controller;
	}

/**
 * init
 *
 * Use the function setup and connection / settings that need setting up in the gateway
 */
	public function setup() {
		if (Configure::read('db.config') === 'live') {
			$this->_config = Configure::read('Transactions.paytrail.live');
		} else {
			$this->_config = Configure::read('Transactions.paytrail.dev');
		}
	}

/**
 * setupPayment
 *
 * Use this function setup the actual payment, i.e. setup the basket, the amount to take etc...
 *
 * @param int - transaction id we have created
 * @param array $return - array with 2 keys of 'return', 'cancel'. Containing either a link or router array for redirecting user
 * @param array $model - array with two keys of 'model' and 'model_id', used to link transactions polymorphically to other model items
 * @param float|array $amount - amount of monies to take (I GOT YOUR MONIESSSSSS), or array of 'amount' and 'currency' to change currencies (will take default from config)
 * @param array $items - multidimenisional array break down of the transaction items, required elements are 'description' and 'amount'
 * @param mixed $extra - variable allowing you to pass ay data needed to the gateway, could be things like addresses that are not tracked by the transactions model
 */
	public function setupPayment($transactionId, $return, $model, $amount, $items, $extra = array()) {

		// Set currency
		if (is_array($amount)) {
			$amount = $amount['amount'];
			$currency = $amount['currency'];
		} else {
			$currency = Configure::read('Transactions.currency');
		}

		// Set url config
		$urlset = new Paytrail_Module_Rest_Urlset(
			$return['return'],
			$return['cancel'],
			Router::url(array(
				'plugin' => 'Transactions',
				'admin' => false,
				'controller' => 'paytrail',
				'action' => 'notify',
			), true),
			"" // Pending url not used
		);

		// Add the transaction item
		$payment = new Paytrail_Module_Rest_Payment_S1($transactionId, $urlset, $amount);

		// Set the locale
		$configLocale = Configure::read('Config.language');
		$currentLocale = !empty($configLocale) ? Configure::read('Config.language') : 'eng';

		$defaultLanguage = $currentLocale;
		$language = !empty($extra['language']) ? $extra['language'] : $defaultLanguage;
		$language = !empty($this->_languages[$language]) ? $this->_languages[$language] : $this->_languages[$defaultLanguage];

		$payment->setLocale($language);

		$module = new Paytrail_Module_Rest($this->_config['merchant_id'], $this->_config['merchant_secret']);
		try {
			$result = $module->processPayment($payment);
		}
		catch (Paytrail_Exception $e) {
			// processing the error
			// Error description available $e->getMessage()
			die("Error in creating payment to Paytrail service");
		}

		header("Location: {$result->getUrl()}");
		die();
	}

/**
 * getPayment
 *
 * Everything should be setup, actually take the payment
 *
 * @param int transactions id
 * @return mixed dependent on the gateway, value is return straight from the transaction component to user anyway
 */
	public function getPayment($transactionId) {
	}

/**
 * return
 *
 * deal with a return from the gateway and check for success / fail
 *
 * @return array - with three elements,
 *               - 'result' = true/false value
 *               - 'message' = text message about transaction (i.e. reason for failing)
 *               - 'transaction_id' = int of the transaction row
 */
	public function processReturn() {
		$this->Transaction = ClassRegistry::init('Transactions.Transaction');
		$this->Transaction->id = $this->__controller->params['url']["ORDER_NUMBER"];

		$module = new Paytrail_Module_Rest($this->_config['merchant_id'], $this->_config['merchant_secret']);
		if ($module->confirmPayment($this->__controller->params['url']["ORDER_NUMBER"], $this->__controller->params['url']["TIMESTAMP"], $this->__controller->params['url']["PAID"], $this->__controller->params['url']["METHOD"], $this->__controller->params['url']["RETURN_AUTHCODE"])) {
			// Payment receipt is valid
			// If needed, the used payment method can be found from the variable $_GET["METHOD"]
			// and order number for the payment from the variable $_GET["ORDER_NUMBER"]

			$this->Transaction->save(array(
				'Transaction' => array(
					'message' => 'Payment successful',
					'payment_token' => $this->__controller->params['url']["METHOD"],
					'status' => 'success'
				)
			));

			return array(
				'result' => true,
				'message' => 'Payment successful',
				'transaction_id' => $this->__controller->params['url']["ORDER_NUMBER"]
			);
		}

		// Payment receipt was not valid, possible payment fraud attempt
		$this->Transaction->save(array(
			'Transaction' => array(
				'status' => 'failed',
				'message' => 'Payment failed'
			)
		));

		return array(
			'result' => false,
			'message' => 'Payment was unsuccessful',
			'transaction_id' => $_GET["ORDER_NUMBER"]
		);
	}

}
