<?php
App::uses('TransactionsAppModel', 'Transactions.Model');

class Transaction extends TransactionsAppModel
{
	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'id';

	public $hasMany = array(
		'TransactionsItem' => array(
			'className' => 'Transactions.TransactionsItem'
		)
	);

	/**
	 * redefiune the model constructor so we can setup the dynamic relationship
	 */
	public function __construct($id = false, $table = null, $ds = null) {

		parent::__construct($id, $table, $ds);

		// setup dynamic relation
		$relation = Configure::read('Transactions.transaction_relation');
		if (! empty($relation)) {

			foreach ($relation as $model => $settings) {

				if (is_numeric($model)) {

					$model = $settings;
					$settings = array();
				}

				$settings['counterCache'] = false;
				$this->belongsTo[$model] = $settings;
			}
		}
	}

	/**
	 * return the array to use for retrieving transaction listing
	 *
	 * @param int user_id we are pulling transactions for
	 * @param int|false int to limit number of rows or false to return all rows
	 * @return array array of data for paginate function / model->find
	 */
	public function transactionListParams($user_id, $limit = false)
	{
		$contain = Configure::read('Transactions.listing.contain');
		$contain = array_merge(array('TransactionsItem'), $contain);

		$return = array(
			'contain' => $contain,
			'conditions' => array(
				'Transaction.user_id' => $user_id
			),
			'order' => 'Transaction.id DESC'
		);

		if ($limit !== false) {

			$return['limit'] = $limit;
		}

		return $return;
	}

}
