<?php
App::uses('TransactionsAppModel', 'Transactions.Model');

class TransactionsItem extends TransactionsAppModel
{
	/**
	 * Display field
	 *
	 * @var string
	 */
	public $displayField = 'description';

	/**
	 * Validation rules
	 *
	 * @var array
	 */
	public $validate = array(
		'description' => array(
			'notempty' => array(
				'rule' => array('notempty'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	/**
	 * belongsTo associations
	 *
	 * @var array
	 */
	public $belongsTo = array(
		'Transaction' => array(
			'className' => 'Transaction',
			'foreignKey' => 'transaction_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

	/**
	 * redefiune the model constructor so we can setup the dynamic relationship
	 */
	public function __construct($id = false, $table = null, $ds = null) {

		parent::__construct($id, $table, $ds);

		// setup dynamic relation
		$relation = Configure::read('Transactions.transactions_item_relation');
		if (! empty($relation)) {

			foreach ($relation as $model => $settings) {

				if (is_numeric($model)) {

					$model = $settings;
					$settings = array();
				}

				$settings['counterCache'] = false;
				$this->belongsTo[$model] = $settings;
			}
		}
	}


}
