<?php

/**
 * Example overriding Config (Define this is /app/Config/Plugin/transactions.php)
 *
 * For the gateway specific config options, you'll have to check the individual gateway components
 *
 * Example taken from Me and My Builder
 */
$config = array(
    'Transactions' => array(
        'gateway' => 'stripe', // must have a valid component, also use the value of this as the key of another element to have settings for that gateway
        'currency' => 'GBP', // used as a generic default, gayeways may have difference requirements for currency definitions,

        'listing' => array(
            'contain' => array('Project'), // contain array to for the my account transactions list / view page
            'page_id' => 13, // content page linked with the transaction listing
            'display_field' => array(
                'Project' => 'name'
            )
        ),

        'transaction_relation' => array(
            'Project' => array(
                'className' => 'Project',
                'foreignKey' => 'model_id',
                'conditions' => array(
                    'model' => 'Project'
                )
            )
        ),
        'transactions_item_relation' => array(
            'Project' => array(
                'className' => 'Project',
                'foreignKey' => 'model_id',
                'conditions' => array(
                    'model' => 'Project'
                )
            )
        ),

        'stripe' => array(
            'live' => array(
                "secret_key"      => "live-secret-key",
                "publishable_key" => "live-publishable-key"
            ),
            'dev' => array(
                "secret_key"      => "test-secret-key",
                "publishable_key" => "test-publishable-key"
            )
        )
    )
);
