/**
 * tinymce plugin that handles adding images into the wysiwyg editor, by opening a dialog
 * window that points at http://coolspirit.dev/admin/ev_tiny_mce_image/image_picker/select, which
 * should be setup to handle the images
 */
tinymce.PluginManager.add('evoluted_image', function(editor, url) {
	var EvTinyMceImage = document.getElementById('EvTinyMceImageConfig');
	if (EvTinyMceImage) {
		// Add a button that opens a window for selecting an image. We only show this when
		// EvTinyMceImageConfig exists; if it doesn't the current page hasn't been configured to use
		// this.
		editor.addButton('evoluted_image', {
			text: 'Insert Image',
			icon: 'image',
			onclick: function() {
				var config = JSON.parse(EvTinyMceImage.getAttribute('data-config'));
				// Open window
				editor.windowManager.open({
					title: 'Insert An Uploaded Image',
					url: '/admin/ev_tiny_mce_image/image_picker/select/' + config.primaryKey + '/' + config.modelAlias,
					height: 600,
					width: 600,
					inline: true
				});
			}
		});
	}
});
