<link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/css/bootstrap.min.css" rel="stylesheet" integrity="sha256-MfvZlkHCEqatNoGiOXveE8FIwMzZg4W85qfrfIFBfYc= sha512-dTfge/zgoMYpP7QbHy4gWMEGsbsdZeCXz7irItjcC3sPUFtf0kuFbDz/ixG7ArTxmDjLXDmezHubeNikyKGVyQ==" crossorigin="anonymous">

<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.4.0/css/font-awesome.min.css" rel="stylesheet" integrity="sha256-k2/8zcNbxVIh5mnQ52A0r3a6jAgMGxFJFE2707UxGCk= sha512-ZV9KawG2Legkwp3nAlxLIVFudTauWuBpC10uEafMHYL0Sarrz5A7G79kXh5+5+woxQ5HM559XX2UZjMJ36Wplg==" crossorigin="anonymous">

<style>
	body {
		background: #ffffff !important;
	}

	.alert {
		margin-bottom: 0px;
	}

	.select-image-wrapper {
		overflow-y: scroll;
		max-height: 412px;
	}

	.select-image-wrapper .admin-image-picker {
		margin:10px;
		border:3px solid white;
		outline:2px solid #cccccc;
		width: 100%;
		height: auto;
		display:block;
		opacity:0.8;
		transition: all 250ms ease-in-out;
	}
	.select-image-wrapper .admin-image-picker:hover {
		opacity:1;
		outline: 2px solid #9FCE8C;
		cursor:pointer;
		transition: all 250ms ease-in-out;
	}

	.select-image-wrapper .admin-image-picker.active {
		outline-color: #00A5E7;
		transition: all 250ms ease-in-out;
		opacity: 1;
	}

	.no-rounding {
		border-radius: 0px;
	}

	.form-footer {
		position: fixed;
		bottom: 0;
		left: 0;
		right: 0;
		padding: 10px;
		background: rgba(0,0,0,0.05);
		border-top: 1px solid rgba(0,0,0,0.08);
	}

	.img-form {
		position: fixed;
		bottom: 35px;
		left: 0;
		right: 0;
		padding: 10px;
		background: rgba(0,0,0,0.02);
		border-top: 1px solid rgba(0,0,0,0.06);
	}

	.form-group {
		margin-bottom: 10px !important;
	}

	img {
		background-image: url('/ev_tiny_mce_image/img/loader.gif');
		width: 100%;
		min-height: 120px;
	}
	img.loaded {
		background: url('/ev_tiny_mce_image/img/chequered.gif') repeat 0 0;
	}

	.dimensions-notice {
		margin: 0 !important;
		padding-bottom: 15px;
		padding-top: 15px;
	}

</style>
<div class="alert alert-success no-rounding">To add images to this section, upload them into any image section displayed on the page and save.</div>
<div class="container-fluid select-image-wrapper">
	<div class="row">
		<div class="col-xs-12">
			<?php
			$dimensionsNotice = 'If no image width dimension is defined, the image will automatically be resized to';

			if (isset($imageDimensions['width'])):
				$dimensionsNotice .= ' ' . $imageDimensions['width'] . 'px wide';
			endif;

			if (isset($imageDimensions['height'])):
				$dimensionsNotice .= ' ' . $imageDimensions['height'] . 'px tall';
			endif;

			$dimensionsNotice .= '.';
			?>
			<p class="dimensions-notice"><?= $dimensionsNotice ?></p>
		</div>
	</div>
	<div class="row">
		<?php foreach ($images as $image) : ?>
			<div class="col-xs-3">
				<?php
				// build the options array depending on what data the image has
				$dimensions = [
					'width' => 450,
					'height' => 450,
					'crop' => true,
				];

				$options = $this->ImagePicker->buildImageOptions($image, $imageDimensions);

				echo $this->Img->resize($image['Image'], $dimensions, $options);
				?>

			</div>
		<?php endforeach; ?>
	</div>
</div>

<form action="#" method="get" class="form-inline img-form">
	<div class="col-xs-4">
		<div class="form-group">
			<label for="imgWidth" class="sr-only">Width</label>
			<input type="text" name="imgWidth" id="imgWidth" class="form-control" placeholder="Width">
		</div>
	</div>
	<div class="col-xs-4">
		<div class="form-group">
			<label for="imgHeight" class="sr-only">Height</label>
			<input type="text" name="imgHeight" id="imgHeight" class="form-control" placeholder="Height (optional)">
		</div>
	</div>

	<div class="col-xs-4">
		<div class="form-group">
			<label for="imgHeight" class="sr-only">Alignment</label>
			<select name="imgAlign" id="imgAlign" class="form-control" placeholder="Alignment">
				<option value="" disabled selected>Image Alignment</option>
				<option value="left">Left</option>
				<option value="center">Centre</option>
				<option value="right">Right</option>
			</select>
		</div>
	</div>
</form>

<div class="form-footer">
	<div class="row">
		<div class="col-xs-6 text-left">
			<button name="closeWindow" id="closeWindow" class="btn btn-danger">
				<i class="fa fa-times-circle"></i> Cancel
			</button>
		</div>
		<div class="col-xs-6 text-right">
			<button name="insertImage" id="insertImage" class="btn btn-success">
				Insert Image <i class="fa fa-chevron-circle-right"></i>
			</button>
		</div>
	</div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js" integrity="sha256-Sk3nkD6mLTMOF0EOpNtsIry+s1CsaqQC1rVLTAy+0yc= sha512-K1qjQ+NcF2TYO/eI3M6v8EiNYZfA95pQumfvcVrTHtwQVDG+aHRqLi/ETn2uB+1JqwYqVG3LIvdm9lj6imS/pQ==" crossorigin="anonymous"></script>

<script>
	$(function() {
		var image_id = 0;
		var ed = parent.tinymce.editors[0];
		var alignment = '';
		var $img = $('img');
		// Define final rendered image dimension vars
		var width = 0;
		var height = 0;
		// assign the default dimensions, when assigned in the plugin config
		var defaultWidth = <?= isset($imageDimensions['width']) ? $imageDimensions['width'] : '0' ?>;
		var defaultHeight = <?= isset($imageDimensions['height']) ? $imageDimensions['height'] : '0' ?>;
		// Define source image size vars
		var srcWidth = 0;
		var srcHeight = 0;

		var alt = '';
		var caption = '';
		var wrappingTag = '<?= h(Configure::read('EvTinyMceImage.wrappingTag')) ?>';
		// Once an image has loaded we want to add a class of 'loaded' so that we can remove the
		// loading gif background and replace it with a chequered background for transparent images.
		// We're using `one` rather than `bind` as we need to take into account images loaded from
		// the cache.
		$img.one('load', function() {
			$(this).addClass('loaded');
		}).each(function() {
			if (this.complete) {
				$(this).load();
			}
		});
		$img.click(function() {

			image_id = $(this).data('image-id');
			image_filepath = $(this).data('image-filepath');
			alt = $(this).attr('alt');
			caption = $(this).data('image-caption');
			srcWidth = parseInt($(this).data('src-width') ? $(this).data('src-width') : 0);
			srcHeight = parseInt($(this).data('src-height') ? $(this).data('src-height') : 0);

			<?php if (Configure::read('EvTinyMceImage.enableWebpSupport')): ?>
				webp_filepath = $(this).data('webp-filepath');
			<?php endif; ?>

			$img.removeClass('active');
			$(this).addClass('active');
		});

		$('#insertImage').on('click', function() {
			if (image_id === 0) {
				alert('Please choose an image');
				return false;
			}
			// Determine the active editor to work with.
			var activeEditor = parent.tinymce.activeEditor;
			// Class name for wrapping paragraph tag.
			var tagClass = null;

			alignment = $('#imgAlign').val();

			if (
				typeof $('#imgWidth') != 'undefined' &&
				$('#imgWidth').val() != ''
			) {
				width = parseInt($('#imgWidth').val());
			}

			if (
				typeof $('#imgHeight') != 'undefined' &&
				$('#imgHeight').val() != ''
			) {
				height = parseInt($('#imgHeight').val());
			}

			// If both width and height are still 0, use defaults
			if (width === 0 && height === 0) {
				width = defaultWidth;
				height = defaultHeight;
			}

			// If only one of width or height has been supplied, work out the other
			// Bypass if both have been supplied even if proportions are off
			if ((width === 0 || height === 0) && srcWidth !== 0 && srcHeight !== 0) {
				if (width > 0 && height === 0) {
					height = (width/srcWidth) * srcHeight;
				} else if (width === 0 && height > 0) {
					width = (height/srcHeight) * srcWidth;
				}
			}

			image_html = '<img src="' + image_filepath + '"';

			if (width > 0) {
				image_html += ' width="' + width + '"';
			}
			if (height > 0) {
				image_html += ' height="' + height + '"';
			}

			if (alignment != null) {
				image_html += ' align="' + alignment + '"';
			}

			// automatically assign the img-responsive Bootstrap class
			image_html += ' class="img-responsive"';

			// add alt attribute
			if (alt.length > 0) {
				image_html += ' alt="' + alt + '"'
			}

			image_html += '>';

			<?php
				if (Configure::read('EvTinyMceImage.includeCaptions')):
				$captionElement = !empty(Configure::read('EvTinyMceImage.captionTag')) ? Configure::read('EvTinyMceImage.captionTag') : 'figcaption';
			?>
			if (caption.length) {
				image_html += '<<?=$captionElement?>>' + caption + '</<?=$captionElement?>>';
			}
			<?php endif; ?>

			// If aligning the image we want to be able to assign a class to the wrapping tag so
			// that we can float the paragraph to ensure siblings wrap correctly and the tag
			// doesn't push the next sibling down a line.
			if (alignment === 'left') {
				tagClass = '<?= h(Configure::read('EvTinyMceImage.alignment.left')) ?>';
			} else if (alignment === 'right') {
				tagClass = '<?= h(Configure::read('EvTinyMceImage.alignment.right')) ?>';
			} else if (alignment === 'center') {
				tagClass = '<?= h(Configure::read('EvTinyMceImage.alignment.center')) ?>';
			}

			<?php if (Configure::read('EvTinyMceImage.enableWebpSupport')): ?>
				image_html = '<source srcset="' + webp_filepath + '" type="image/webp">' + image_html;
				image_html = '<picture>' + image_html + '</picture>';
			<?php endif; ?>

			if (tagClass !== null) {
				image_html = '<' + wrappingTag + ' data-ev class="' + tagClass + '">' + image_html + '</' + wrappingTag + '>';
			} else {
				image_html = '<' + wrappingTag + ' data-ev>' + image_html + '</' + wrappingTag + '>';
			}

			activeEditor.selection.setContent(image_html);
			activeEditor.windowManager.windows[0].close();
		});

		$('#closeWindow').on('click', function() {
			parent.tinymce.activeEditor.windowManager.windows[0].close();
		});
	});
</script>


