<?php

App::uses('AppHelper', 'View/Helper');

class ImagePickerHelper extends AppHelper {

/**
 * Default Constructor. Redifined to add additional helpers.
 *
 * @param View $View The View this helper is being attached to.
 * @param array $settings Configuration settings for the helper.
 */
	public function __construct(View $View, $settings = []) {
		$this->helpers[] = 'Img';

		parent::__construct($View, $settings);
	}

/**
 * Build the Options Array for the TinyMCE thumbnail images
 *
 * @param array $image The image being processed
 * @param array $imageDimensions Default image dimensions
 * @return array $options The options for the thumbnail image
 */
	public function buildImageOptions($image, $imageDimensions) {

		// Determine original image dimensions
		$filepath = WWW_ROOT . $image['Image']['filepath'];

		if (file_exists($filepath)) {
			$imageSize = getimagesize($filepath);
		}

		// Build options array
		$options = [
			'class'=> 'admin-image-picker',
			'data-image-id' => $image['Image']['id'],
			'data-image-filepath' => $this->Img->path($image['Image'], $imageDimensions),
			'data-image-caption' => !empty($image['Image']['caption']) ? $image['Image']['caption'] : null,
			'data-src-width' => !empty($imageSize[0]) ? $imageSize[0] : null,
			'data-src-height' => !empty($imageSize[1]) ? $imageSize[1] : null,
			'style' => 'margin-left:auto;margin-right:auto;display:block;'
		];

		// Enable WEBP support where possible
		if (Configure::read('EvTinyMceImage.enableWebpSupport')) {
			$options['data-webp-filepath'] = $this->Img->path($image['Image'], $imageDimensions, null, false, true);
		}

		return $options;
	}
}
