# EVTinyMCEImagePicker
========================

## About
Allows you to add an image insert tool in TinyMCE that pulls images from your image tabs.

General features include image resize options during insert as well as alignment options.

Based on Tom's REBA plugin and extended by Rick.

## Installation
Run `composer require evoluted/tinymceimage`

## Setup
There are quite a few steps for setting up this plugin to enable images in the TinyMce editor, but they are very straight forward:

1) Make sure that your model has an image association, this can be any named image slot e.g.

	public $imageSlots = array(
		'main' => array(
			'slots' => -1,
			'fields' => array(
				'alt'
			)
		),
	);

2) Inside your controller add the following to your $components array

    'EvTinyMceImage.TinyMCE' => [
		'model_alias' => 'SupportBlogPost'
	],

Where `model_alias` is the alias of the model.

3) Look for the `$.fn.wysiwygEditor.defaults` array in your `admin_form.js` file and make the following changes:

Add evoluted_image to the "external_plugins" key or set it like so -

	'external_plugins': {
	    'evoluted_image': '/ev_tiny_mce_image/js/plugin.min.js'
	},


Add `evoluted_image` to the "toolbar" key (the button will only show in editors for content that have been configured to use the Component).

Lastly, make sure the img tag and any attributes are allowed by adding `img[*]` to the list of valid elements. You may need to add your overriding wrapping tag too.

### Image Dimensions

Image dimensions can be assigned and edited in the plugin config file.

	$config = [
		'EvTinyMceImage' => [
			'dimensions' => [
				'height' => 500,
				'width' => 500
			]
		]
	];

### Wrapping Tag

This defines the tag inside which the image is wrapped. By default this is a Paragraph tag.

	$config = [
		'EvTinyMceImage' => [
			'wrappingTag' => 'p'
		]
	];

### Alignment Classes

To correctly align images with siblings the wrapping tag needs floating (otherwise the wrapping tag pushed the content down). The plugin applies Bootstrap classes to the wrapping tag for alignment which can be overridden in the config file:-

	$config = [
		'EvTinyMceImage' => [
			'alignment' => [
				'left' => 'pull-left',
				'right' => 'pull-right',
				'center' => 'text-center'
			]
		]
	];

Set the class to `null` to prevent a class from being applied.

* If you need to make a `ul` list align correctly with an image you need to apply `overflow: hidden` to the `ul`.
* To use `.text-center` for centring an image you need to add the CSS rule `.text-center .img-responsive { display: inline-block; }`.

### Model specific config
You may specify config that should only be used for a specific model by specifying the model alias inside your overridden
config as shown below. When present this will OVERRIDE any other configuration.
```php
$config = [
	'EvTinyMceImage' => [
		'BlogPost' => [
			'dimensions' => [
				'width' => 1e3
			]
		]
	]
];
```

### webp Support

If you're using version 2.0.14.0 of EvImg or higher, you can enable webp support with this plugin by setting `enableWebpSupport` to true in the config. This will generate `<picture>` and `<source>` markup when generating the images so that webp images can be served to browsers that support the format. You will need to update `valid_elements` for TinyMCE to allow the tags `picture,source[*]` otherwise they will be stripped for the generated HTML.
